/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;
import javax.media.jai.PlanarImage;
import org.esa.beam.dataio.netcdf.util.DimKey;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;

public class NetcdfOpImage
extends SingleBandedOpImage {
    private final Variable variable;
    private final boolean flipY;
    private final int sourceHeight;
    private final int[] imageOrigin;
    private final Object readLock;
    private final ArrayConverter arrayConverter;
    private final int xIndex;
    private final int yIndex;
    private final int startIndexToCopy;

    public static RenderedImage createLsbImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return new NetcdfOpImage(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.LSB);
    }

    public static RenderedImage createMsbImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return new NetcdfOpImage(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.MSB);
    }

    public NetcdfOpImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        this(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.IDENTITY);
    }

    private NetcdfOpImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, ArrayConverter arrayConverter) {
        super(dataBufferType, sourceWidth, sourceHeight, tileSize, null, level);
        this.variable = variable;
        this.imageOrigin = (int[])imageOrigin.clone();
        this.readLock = readLock;
        this.flipY = flipY;
        this.sourceHeight = sourceHeight;
        this.arrayConverter = arrayConverter;
        List variableDimensions = variable.getDimensions();
        DimKey rasterDim = new DimKey(variableDimensions.toArray(new ucar.nc2.Dimension[variableDimensions.size()]));
        this.xIndex = rasterDim.findXDimensionIndex();
        this.yIndex = rasterDim.findYDimensionIndex();
        this.startIndexToCopy = DimKey.findStartIndexOfBandVariables(variableDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        Array array;
        Rectangle sourceRect = this.getLevel() != 0 ? this.getSourceRect(destRect) : destRect;
        int rank = this.variable.getRank();
        int[] origin = new int[rank];
        int[] shape = new int[rank];
        int[] stride = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shape[i] = 1;
            origin[i] = 0;
            stride[i] = 1;
        }
        shape[this.yIndex] = sourceRect.height;
        shape[this.xIndex] = sourceRect.width;
        if (this.imageOrigin.length >= 0) {
            System.arraycopy(this.imageOrigin, 0, origin, this.startIndexToCopy, this.imageOrigin.length);
        }
        origin[this.yIndex] = this.flipY ? this.sourceHeight - sourceRect.y - sourceRect.height : sourceRect.y;
        origin[this.xIndex] = sourceRect.x;
        double scale = this.getScale();
        stride[this.yIndex] = (int)scale;
        stride[this.xIndex] = (int)scale;
        Object object = this.readLock;
        synchronized (object) {
            try {
                Section section = new Section(origin, shape, stride);
                array = this.variable.read(section);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.xIndex < this.yIndex) {
            array = array.transpose(this.xIndex, this.yIndex);
        }
        Array convertedArray = this.arrayConverter.convert(array);
        if (this.flipY) {
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, convertedArray.flip(this.yIndex).copyTo1DJavaArray());
        } else {
            Object data = this.xIndex < this.yIndex ? convertedArray.copyTo1DJavaArray() : convertedArray.getStorage();
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, data);
        }
    }

    private Rectangle getSourceRect(Rectangle rect) {
        int sourceX = this.getSourceX(rect.x);
        int sourceY = this.getSourceY(rect.y);
        int sourceWidth = this.getSourceWidth(rect.width);
        int sourceHeight = this.getSourceHeight(rect.height);
        return new Rectangle(sourceX, sourceY, sourceWidth, sourceHeight);
    }

    private static interface ArrayConverter {
        public static final ArrayConverter IDENTITY = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                return array;
            }
        };
        public static final ArrayConverter LSB = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                Array convertedArray = Array.factory((DataType)DataType.INT, (int[])array.getShape());
                int i = 0;
                while ((long)i < convertedArray.getSize()) {
                    convertedArray.setInt(i, (int)(array.getLong(i) & 0xFFFFFFFFL));
                    ++i;
                }
                return convertedArray;
            }
        };
        public static final ArrayConverter MSB = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                Array convertedArray = Array.factory((DataType)DataType.INT, (int[])array.getShape());
                int i = 0;
                while ((long)i < convertedArray.getSize()) {
                    convertedArray.setInt(i, (int)(array.getLong(i) >>> 32));
                    ++i;
                }
                return convertedArray;
            }
        };

        public Array convert(Array var1);
    }
}

