/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import com.bc.ceres.core.Assert;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class DimKey {
    private static final String[] TYPICAL_X_DIM_NAMES = new String[]{"lon", "long", "longitude", "ni", "NX", "SX", "x"};
    private static final String[] TYPICAL_Y_DIM_NAMES = new String[]{"lat", "lat", "latitude", "nj", "NY", "SY", "y"};
    private final Dimension[] dims;
    private final int xDimIndex;
    private final int yDimIndex;

    public DimKey(Dimension ... dims) {
        Assert.argument((dims.length >= 1 ? 1 : 0) != 0, (String)"dims.length >= 1");
        for (Dimension dim : dims) {
            Assert.notNull((Object)dim, (String)"dim");
        }
        this.dims = dims;
        this.xDimIndex = this.findXDimensionIndex();
        this.yDimIndex = this.findYDimensionIndex();
    }

    public int findXDimensionIndex() {
        for (int i = 0; i < this.dims.length; ++i) {
            String dimName = this.dims[i].getName();
            if (dimName == null) continue;
            for (String typicalXDimName : TYPICAL_X_DIM_NAMES) {
                if (!dimName.equalsIgnoreCase(typicalXDimName)) continue;
                return i;
            }
        }
        return this.getRank() - 1;
    }

    public int findYDimensionIndex() {
        for (int i = 0; i < this.dims.length; ++i) {
            String dimName = this.dims[i].getName();
            if (dimName == null) continue;
            for (String typicalYDimName : TYPICAL_Y_DIM_NAMES) {
                if (!this.dims[i].getName().equalsIgnoreCase(typicalYDimName)) continue;
                return i;
            }
        }
        return this.getRank() - 2;
    }

    public static int findStartIndexOfBandVariables(List<Dimension> dimensions) {
        DimKey rasterDim = new DimKey(dimensions.toArray(new Dimension[dimensions.size()]));
        int xIndex = rasterDim.findXDimensionIndex();
        int yIndex = rasterDim.findYDimensionIndex();
        if (xIndex == 0 || yIndex == 0) {
            return 2;
        }
        if (xIndex == dimensions.size() - 1 || yIndex == dimensions.size() - 1) {
            return 0;
        }
        return -1;
    }

    public int getRank() {
        return this.dims.length;
    }

    public Dimension getDimensionX() {
        return this.getDimension(this.xDimIndex);
    }

    public Dimension getDimensionY() {
        return this.getDimension(this.yDimIndex);
    }

    public Dimension getDimension(int index) {
        return this.dims[index];
    }

    public boolean isTypicalRasterDim() {
        boolean isTypicalRasterDim = false;
        for (int i = 0; i < TYPICAL_X_DIM_NAMES.length; ++i) {
            isTypicalRasterDim = isTypicalRasterDim || this.matchesXYDimNames(TYPICAL_X_DIM_NAMES[i], TYPICAL_Y_DIM_NAMES[i]);
        }
        return isTypicalRasterDim;
    }

    public boolean fitsTo(Variable varX, Variable varY) {
        return varX.getRank() == 1 && varY.getRank() == 1 && varX.getDimension(0).getLength() == this.getDimensionX().getLength() && varY.getDimension(0).getLength() == this.getDimensionY().getLength();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimKey dimKey = (DimKey)o;
        return this.getDimensionY().getLength() == dimKey.getDimensionY().getLength() && this.getDimensionX().getLength() == dimKey.getDimensionX().getLength();
    }

    public int hashCode() {
        return 31 * this.getDimensionY().getLength() + this.getDimensionX().getLength();
    }

    private boolean matchesXYDimNames(String xName, String yName) {
        if (this.getDimensionX().getName() != null && this.getDimensionY().getName() != null) {
            return this.getDimensionX().getName().equalsIgnoreCase(xName) && this.getDimensionY().getName().equalsIgnoreCase(yName);
        }
        return false;
    }
}

