/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import org.esa.beam.framework.datamodel.ProductData;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class DataTypeUtils {
    public static boolean isValidRasterDataType(DataType dataType) {
        boolean unsigned = false;
        return DataTypeUtils.getRasterDataType(dataType, false) != -1;
    }

    public static int getRasterDataType(Variable variable) {
        return DataTypeUtils.getRasterDataType(variable.getDataType(), variable.isUnsigned());
    }

    public static int getRasterDataType(DataType dataType, boolean unsigned) {
        boolean rasterDataOnly = true;
        return DataTypeUtils.getEquivalentProductDataType(dataType, unsigned, true);
    }

    public static int getEquivalentProductDataType(DataType dataType, boolean unsigned, boolean rasterDataOnly) {
        if (dataType == DataType.BYTE) {
            return unsigned ? 20 : 10;
        }
        if (dataType == DataType.SHORT) {
            return unsigned ? 21 : 11;
        }
        if (dataType == DataType.INT) {
            return unsigned ? 22 : 12;
        }
        if (dataType == DataType.FLOAT) {
            return 30;
        }
        if (dataType == DataType.DOUBLE) {
            return 31;
        }
        if (!rasterDataOnly) {
            if (dataType == DataType.CHAR) {
                return 41;
            }
            if (dataType == DataType.STRING) {
                return 41;
            }
        }
        return -1;
    }

    public static DataType getNetcdfDataType(int dataType) {
        if (dataType == 10 || dataType == 20) {
            return DataType.BYTE;
        }
        if (dataType == 11 || dataType == 21) {
            return DataType.SHORT;
        }
        if (dataType == 12 || dataType == 22) {
            return DataType.INT;
        }
        if (dataType == 30) {
            return DataType.FLOAT;
        }
        if (dataType == 31) {
            return DataType.DOUBLE;
        }
        if (dataType == 41) {
            return DataType.STRING;
        }
        if (dataType == 51) {
            return DataType.STRING;
        }
        return null;
    }

    public static Number convertTo(double value, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return (byte)value;
            }
            case SHORT: {
                return (short)value;
            }
            case INT: {
                return (int)value;
            }
            case LONG: {
                return (long)value;
            }
            case FLOAT: {
                return Float.valueOf((float)value);
            }
            case DOUBLE: {
                return value;
            }
        }
        throw new IllegalArgumentException("Can not convert data type:" + dataType.name());
    }

    public static ProductData createProductData(Attribute attribute) {
        int productDataType = DataTypeUtils.getEquivalentProductDataType(attribute.getDataType(), false, false);
        ProductData attributeValue = productDataType == 41 ? ProductData.createInstance((String)attribute.getStringValue()) : ProductData.createInstance((int)productDataType, (Object)attribute.getValues().copyTo1DJavaArray());
        return attributeValue;
    }
}

