/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;

public abstract class AbstractNetcdfMultiLevelImage
extends MultiLevelImage {
    private final RasterDataNode rasterDataNode;
    private final int levelCount;
    private final RenderedImage[] levelImages;
    private MultiLevelModel multiLevelModel;

    protected AbstractNetcdfMultiLevelImage(RasterDataNode rasterDataNode) {
        super(ImageManager.createSingleBandedImageLayout((RasterDataNode)rasterDataNode), null, null);
        this.rasterDataNode = rasterDataNode;
        int width = rasterDataNode.getSceneRasterWidth();
        int height = rasterDataNode.getSceneRasterHeight();
        this.levelCount = DefaultMultiLevelModel.getLevelCount((int)width, (int)height);
        this.levelImages = new RenderedImage[this.levelCount];
    }

    protected RasterDataNode getRasterDataNode() {
        return this.rasterDataNode;
    }

    public synchronized MultiLevelModel getModel() {
        if (this.multiLevelModel == null) {
            this.multiLevelModel = ImageManager.createMultiLevelModel((ProductNode)this.rasterDataNode);
        }
        return this.multiLevelModel;
    }

    public synchronized RenderedImage getImage(int level) {
        this.checkLevel(level);
        RenderedImage levelImage = this.levelImages[level];
        if (levelImage == null) {
            this.levelImages[level] = levelImage = this.createImage(level);
        }
        return levelImage;
    }

    protected abstract RenderedImage createImage(int var1);

    public Shape getImageShape(int level) {
        return null;
    }

    public void reset() {
        for (int level = 0; level < this.levelImages.length; ++level) {
            RenderedImage levelImage = this.levelImages[level];
            if (levelImage instanceof PlanarImage) {
                PlanarImage planarImage = (PlanarImage)levelImage;
                planarImage.dispose();
            }
            this.levelImages[level] = null;
        }
    }

    public void dispose() {
        this.reset();
        super.dispose();
    }

    protected static Dimension getPreferredTileSize(RasterDataNode rdn) {
        Product product = rdn.getProduct();
        if (product != null && product.getPreferredTileSize() != null) {
            return product.getPreferredTileSize();
        }
        return null;
    }

    private void checkLevel(int level) {
        if (level < 0 || level >= this.levelCount) {
            throw new IllegalArgumentException("level=" + level);
        }
    }
}

