/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.nc;

import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import org.esa.beam.dataio.netcdf.nc.ChunkWriter;
import org.esa.beam.dataio.netcdf.nc.N4DataType;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.framework.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class N4Variable
implements NVariable {
    private final NhVariable variable;
    private final Dimension tileSize;
    private ChunkWriter writer;

    public N4Variable(NhVariable variable, Dimension tileSize) {
        this.variable = variable;
        this.tileSize = tileSize;
    }

    @Override
    public String getName() {
        return this.variable.getName();
    }

    @Override
    public DataType getDataType() {
        int type = this.variable.getType();
        return N4DataType.convert(type);
    }

    @Override
    public void addAttribute(String name, String value) throws IOException {
        this.addAttributeImpl(name, value, 9);
    }

    @Override
    public void addAttribute(String name, Number value) throws IOException {
        DataType dataType = DataType.getType(value.getClass());
        int nhType = N4DataType.convert(dataType, false);
        this.addAttributeImpl(name, value, nhType);
    }

    @Override
    public void addAttribute(String name, Array value) throws IOException {
        DataType dataType = DataType.getType((Class)value.getElementType());
        int nhType = N4DataType.convert(dataType, false);
        this.addAttributeImpl(name, value.getStorage(), nhType);
    }

    private void addAttributeImpl(String name, Object value, int type) throws IOException {
        name = name.replace('.', '_');
        try {
            this.variable.addAttribute(name, type, value);
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeFully(Array values) throws IOException {
        int[] idxes = new int[values.getShape().length];
        try {
            this.variable.writeData(idxes, (Object)values);
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int x, int y, int width, int height, boolean isYFlipped, ProductData data) throws IOException {
        if (this.writer == null) {
            this.writer = this.createWriter(isYFlipped);
        }
        this.writer.write(x, y, width, height, data);
    }

    ChunkWriter createWriter(boolean isYFlipped) {
        NhDimension[] nhDimensions = this.variable.getDimensions();
        int sceneWidth = nhDimensions[1].getLength();
        int sceneHeight = nhDimensions[0].getLength();
        int chunkWidth = this.tileSize.width;
        int chunkHeight = this.tileSize.height;
        return new ChunkWriter(sceneWidth, sceneHeight, chunkWidth, chunkHeight, isYFlipped){

            @Override
            public void writeChunk(Rectangle rect, ProductData data) throws IOException {
                int[] origin = new int[]{rect.y, rect.x};
                int[] shape = new int[]{rect.height, rect.width};
                DataType dataType = N4DataType.convert(N4Variable.this.variable.getType());
                Array values = Array.factory((DataType)dataType, (int[])shape, (Object)data.getElems());
                try {
                    N4Variable.this.variable.writeData(origin, (Object)values);
                }
                catch (NhException e) {
                    throw new IOException(e);
                }
            }
        };
    }
}

