/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.nc;

import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.awt.Dimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.dataio.netcdf.nc.N4DataType;
import org.esa.beam.dataio.netcdf.nc.N4Variable;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import ucar.ma2.DataType;

public class N4FileWriteable
implements NFileWriteable {
    private static final int DEFAULT_COMPRESSION = 6;
    private final NhFileWriter nhFileWriter;
    private Map<String, NVariable> variables;

    public static NFileWriteable create(String filename) throws IOException {
        try {
            return new N4FileWriteable(new NhFileWriter(filename, 1));
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    private N4FileWriteable(NhFileWriter nhFileWriter) {
        this.nhFileWriter = nhFileWriter;
        this.variables = new HashMap<String, NVariable>();
    }

    @Override
    public void addDimension(String name, int length) throws IOException {
        try {
            this.nhFileWriter.getRootGroup().addDimension(name, length);
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getDimensions() {
        NhGroup rootGroup = this.nhFileWriter.getRootGroup();
        NhDimension[] dimensions = rootGroup.getDimensions();
        StringBuilder out = new StringBuilder();
        for (NhDimension dim : dimensions) {
            out.append(dim.getName()).append(" ");
        }
        return out.toString();
    }

    @Override
    public void addGlobalAttribute(String name, String value) throws IOException {
        try {
            this.nhFileWriter.getRootGroup().addAttribute(name, 9, (Object)value);
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NVariable addScalarVariable(String name, DataType dataType) throws IOException {
        NhGroup rootGroup = this.nhFileWriter.getRootGroup();
        boolean unsigned = false;
        int nhType = N4DataType.convert(dataType, unsigned);
        try {
            NhVariable variable = rootGroup.addVariable(name, nhType, new NhDimension[0], new int[0], null, 0);
            N4Variable nVariable = new N4Variable(variable, null);
            this.variables.put(name, nVariable);
            return nVariable;
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NVariable addVariable(String name, DataType dataType, Dimension tileSize, String dimensions) throws IOException {
        NhGroup rootGroup = this.nhFileWriter.getRootGroup();
        boolean unsigned = false;
        int nhType = N4DataType.convert(dataType, unsigned);
        String[] dims = dimensions.split(" ");
        NhDimension[] nhDims = new NhDimension[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            nhDims[i] = rootGroup.findLocalDimension(dims[i]);
        }
        int[] chunkLens = new int[dims.length];
        if (tileSize != null) {
            chunkLens[0] = tileSize.height;
            chunkLens[1] = tileSize.width;
        } else {
            for (int i = 0; i < dims.length; ++i) {
                chunkLens[i] = nhDims[i].getLength();
            }
        }
        Object fillValue = null;
        try {
            NhVariable variable = rootGroup.addVariable(name, nhType, nhDims, chunkLens, fillValue, 6);
            N4Variable nVariable = new N4Variable(variable, tileSize);
            this.variables.put(name, nVariable);
            return nVariable;
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NVariable findVariable(String variableName) {
        return this.variables.get(variableName);
    }

    @Override
    public void create() throws IOException {
        try {
            this.nhFileWriter.endDefine();
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.nhFileWriter.close();
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }
}

