/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.nc;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import org.esa.beam.dataio.netcdf.nc.N3Variable;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class N3FileWriteable
implements NFileWriteable {
    private final NetcdfFileWriteable netcdfFileWriteable;

    public static NFileWriteable create(String filename) throws IOException {
        NetcdfFileWriteable writeable = NetcdfFileWriteable.createNew((String)filename);
        writeable.setLargeFile(true);
        return new N3FileWriteable(writeable);
    }

    public N3FileWriteable(NetcdfFileWriteable netcdfFileWriteable) {
        this.netcdfFileWriteable = netcdfFileWriteable;
    }

    @Override
    public void addDimension(String name, int length) {
        this.netcdfFileWriteable.addDimension(name, length);
    }

    @Override
    public String getDimensions() {
        return ucar.nc2.Dimension.makeDimensionList((List)this.netcdfFileWriteable.getRootGroup().getDimensions());
    }

    @Override
    public void addGlobalAttribute(String name, String value) {
        this.netcdfFileWriteable.addGlobalAttribute(name, value);
    }

    @Override
    public NVariable addScalarVariable(String name, DataType dataType) throws IOException {
        Variable variable = this.netcdfFileWriteable.addVariable(name, dataType, "");
        return new N3Variable(variable, this.netcdfFileWriteable);
    }

    @Override
    public NVariable addVariable(String name, DataType dataType, Dimension tileSize, String dims) throws IOException {
        Variable variable = this.netcdfFileWriteable.addVariable(name, dataType, dims);
        return new N3Variable(variable, this.netcdfFileWriteable);
    }

    @Override
    public NVariable findVariable(String variableName) {
        Variable variable = this.netcdfFileWriteable.getRootGroup().findVariable(variableName);
        return variable != null ? new N3Variable(variable, this.netcdfFileWriteable) : null;
    }

    @Override
    public void create() throws IOException {
        this.netcdfFileWriteable.create();
    }

    @Override
    public void close() throws IOException {
        this.netcdfFileWriteable.close();
    }
}

