/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import java.io.IOException;
import java.util.Locale;
import org.esa.beam.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosBandPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosDescriptionPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGeocodingPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosMetadataPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosTimePart;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosUtils;
import org.esa.beam.dataio.netcdf.util.RasterDigest;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductIOException;
import org.jdom.Element;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;

public class HdfEosNetCdfReaderPlugIn
extends AbstractNetCdfReaderPlugIn {
    @Override
    protected DecodeQualification getDecodeQualification(NetcdfFile netcdfFile) {
        try {
            Element eosElement = HdfEosUtils.getEosElement("StructMetadata", netcdfFile.getRootGroup());
            String gridName = this.getGridName(eosElement);
            if (gridName == null || gridName.isEmpty()) {
                return DecodeQualification.UNABLE;
            }
            Element gridStructure = eosElement.getChild("GridStructure");
            Element gridElem = (Element)gridStructure.getChildren().get(0);
            Element projectionElem = gridElem.getChild("Projection");
            if (projectionElem == null) {
                return DecodeQualification.UNABLE;
            }
            String projection = projectionElem.getValue();
            if (projection.equals("GCTP_GEO") || projection.equals("GCTP_SNSOID")) {
                return DecodeQualification.INTENDED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    protected void initReadContext(ProfileReadContext ctx) throws IOException {
        Group eosGroup = ctx.getNetcdfFile().getRootGroup();
        Element eosStructElement = HdfEosUtils.getEosElement("StructMetadata", eosGroup);
        String gridName = this.getGridName(eosStructElement);
        if (gridName == null || gridName.isEmpty()) {
            throw new ProductIOException("Could not find grid.");
        }
        Group gridGroup = HdfEosUtils.findGroupNested(eosGroup, gridName);
        if (gridGroup == null) {
            throw new ProductIOException("Could not find grid group.");
        }
        RasterDigest rasterDigest = RasterDigest.createRasterDigest(gridGroup);
        ctx.setRasterDigest(rasterDigest);
        ctx.setProperty("StructMetadata", eosStructElement);
        ctx.setProperty("CoreMetadata", HdfEosUtils.getEosElement("CoreMetadata", eosGroup));
        ctx.setProperty("ArchiveMetadata", HdfEosUtils.getEosElement("ArchiveMetadata", eosGroup));
    }

    @Override
    public ProfileInitPartReader createInitialisationPartReader() {
        return new CfInitialisationPart();
    }

    public String[] getFormatNames() {
        return new String[]{"HDF-EOS"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".hdf", ".hdf.gz"};
    }

    public String getDescription(Locale locale) {
        return "HDF-EOS products";
    }

    @Override
    public ProfilePartReader createBandPartReader() {
        return new HdfEosBandPart();
    }

    @Override
    public ProfilePartReader createGeoCodingPartReader() {
        return new HdfEosGeocodingPart();
    }

    @Override
    public ProfilePartReader createTimePartReader() {
        return new HdfEosTimePart();
    }

    @Override
    public ProfilePartReader createDescriptionPartReader() {
        return new HdfEosDescriptionPart();
    }

    @Override
    public ProfilePartReader createMetadataPartReader() {
        return new HdfEosMetadataPart();
    }

    private String getGridName(Element eosElement) throws IOException {
        Element gridNameElem;
        Element gridElem;
        Element gridStructure;
        if (eosElement != null && (gridStructure = eosElement.getChild("GridStructure")) != null && gridStructure.getChildren() != null && !gridStructure.getChildren().isEmpty() && (gridElem = (Element)gridStructure.getChildren().get(0)) != null && (gridNameElem = gridElem.getChild("GridName")) != null) {
            return gridNameElem.getText();
        }
        return null;
    }
}

