/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.util.MetadataUtils;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.jdom.Attribute;
import org.jdom.Element;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class HdfEosMetadataPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile ncFile = ctx.getNetcdfFile();
        MetadataElement root = p.getMetadataRoot();
        root.addElement(MetadataUtils.readAttributeList(ncFile.getGlobalAttributes(), "MPH"));
        MetadataElement eosElem = new MetadataElement("EOS");
        HdfEosMetadataPart.createMDE("StructMetadata", ctx, eosElem);
        HdfEosMetadataPart.createMDE("CoreMetadata", ctx, eosElem);
        HdfEosMetadataPart.createMDE("ArchiveMetadata", ctx, eosElem);
        root.addElement(eosElem);
        List ncVariables = ncFile.getVariables();
        this.filterVariableList(ncVariables);
        root.addElement(MetadataUtils.readVariableDescriptions(ncVariables, "DSD"));
    }

    private void filterVariableList(List<Variable> ncVariables) {
        Iterator<Variable> variableIterator = ncVariables.iterator();
        while (variableIterator.hasNext()) {
            Variable variable = variableIterator.next();
            String varName = variable.getName();
            if (!varName.startsWith("StructMetadata") && !varName.startsWith("CoreMetadata") && !varName.startsWith("ArchiveMetadata")) continue;
            variableIterator.remove();
        }
    }

    private static void createMDE(String name, ProfileReadContext ctx, MetadataElement eosElem) throws IOException {
        Element element = (Element)ctx.getProperty(name);
        if (element != null) {
            MetadataElement metadataElement = new MetadataElement(name);
            HdfEosMetadataPart.addDomToMetadata(element, metadataElement);
            eosElem.addElement(metadataElement);
        }
    }

    private static void addDomToMetadata(Element parentDE, MetadataElement parentME) {
        List elementList;
        String name;
        HashMap map = new HashMap(25);
        List children = parentDE.getChildren();
        for (Element element : children) {
            name = element.getName();
            elementList = (ArrayList<Element>)map.get(name);
            if (elementList == null) {
                elementList = new ArrayList<Element>(3);
                map.put(name, elementList);
            }
            elementList.add(element);
        }
        for (Map.Entry entry : map.entrySet()) {
            name = (String)entry.getKey();
            elementList = (List)entry.getValue();
            if (elementList.size() > 1) {
                for (int i = 0; i < elementList.size(); ++i) {
                    HdfEosMetadataPart.addDomToMetadata((Element)elementList.get(i), name + "." + i, parentME);
                }
                continue;
            }
            HdfEosMetadataPart.addDomToMetadata((Element)elementList.get(0), name, parentME);
        }
    }

    private static void addDomToMetadata(Element childDE, String name, MetadataElement parentME) {
        if (childDE.getChildren().size() > 0 || childDE.getAttributes().size() > 0) {
            MetadataElement childME = new MetadataElement(name);
            HdfEosMetadataPart.addDomToMetadata(childDE, childME);
            parentME.addElement(childME);
            if (childDE.getAttributes().size() != 0) {
                List attrList = childDE.getAttributes();
                for (Object o : attrList) {
                    Attribute attribute = (Attribute)o;
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getValue();
                    ProductData valueMEAtrr = ProductData.createInstance((String)attributeValue);
                    MetadataAttribute mdAttribute = new MetadataAttribute(attributeName, valueMEAtrr, true);
                    childME.addAttribute(mdAttribute);
                }
            }
        } else {
            String valueDE = childDE.getValue();
            if (valueDE == null) {
                valueDE = "";
            }
            ProductData valueME = ProductData.createInstance((String)valueDE);
            MetadataAttribute attribute = new MetadataAttribute(name, valueME, true);
            parentME.addAttribute(attribute);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        throw new IllegalStateException();
    }
}

