/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.jdom.Element;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class HdfEosGeocodingPart
extends ProfilePartIO {
    private static final double PIXEL_CENTER = 0.5;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Element eosElement = (Element)ctx.getProperty("StructMetadata");
        Element gridStructure = eosElement.getChild("GridStructure");
        Element gridElem = (Element)gridStructure.getChildren().get(0);
        Element projectionElem = gridElem.getChild("Projection");
        Element ulPointElem = gridElem.getChild("UpperLeftPointMtrs");
        Element lrPointElem = gridElem.getChild("LowerRightMtrs");
        if (projectionElem == null || ulPointElem == null || lrPointElem == null) {
            return;
        }
        List ulList = ulPointElem.getChildren();
        String ulLon = ((Element)ulList.get(0)).getValue();
        String ulLat = ((Element)ulList.get(1)).getValue();
        double upperLeftLon = Double.parseDouble(ulLon);
        double upperLeftLat = Double.parseDouble(ulLat);
        List lrList = lrPointElem.getChildren();
        String lrLon = ((Element)lrList.get(0)).getValue();
        String lrLat = ((Element)lrList.get(1)).getValue();
        double lowerRightLon = Double.parseDouble(lrLon);
        double lowerRightLat = Double.parseDouble(lrLat);
        String projection = projectionElem.getValue();
        HdfEosGeocodingPart.attachGeoCoding(p, upperLeftLon, upperLeftLat, lowerRightLon, lowerRightLat, projection);
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        throw new IllegalStateException();
    }

    public static void attachGeoCoding(Product p, double upperLeftLon, double upperLeftLat, double lowerRightLon, double lowerRightLat, String projection) {
        double pixelSizeX = (lowerRightLon - upperLeftLon) / (double)p.getSceneRasterWidth();
        double pixelSizeY = (upperLeftLat - lowerRightLat) / (double)p.getSceneRasterHeight();
        AffineTransform transform = new AffineTransform();
        transform.translate(upperLeftLon, upperLeftLat);
        transform.scale(pixelSizeX, -pixelSizeY);
        transform.translate(-0.5, -0.5);
        Rectangle imageBounds = new Rectangle(p.getSceneRasterWidth(), p.getSceneRasterHeight());
        if (projection.equals("GCTP_GEO")) {
            if (upperLeftLon >= -180.0 && upperLeftLon <= 180.0 && upperLeftLat >= -90.0 && upperLeftLat <= 90.0 && lowerRightLon >= -180.0 && lowerRightLon <= 180.0 && lowerRightLat >= -90.0 && lowerRightLat <= 90.0) {
                try {
                    p.setGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, imageBounds, transform));
                }
                catch (FactoryException ignore) {
                }
                catch (TransformException ignore) {}
            }
        } else if (projection.equals("GCTP_SNSOID")) {
            MathTransform mathTransform;
            ParameterValueGroup parameters;
            DefaultGeographicCRS base = DefaultGeographicCRS.WGS84;
            MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
            try {
                parameters = transformFactory.getDefaultParameters("OGC:Sinusoidal");
            }
            catch (NoSuchIdentifierException ignore) {
                return;
            }
            DefaultEllipsoid ellipsoid = (DefaultEllipsoid)base.getDatum().getEllipsoid();
            parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis());
            parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis());
            try {
                mathTransform = transformFactory.createParameterizedTransform(parameters);
            }
            catch (Exception ignore) {
                return;
            }
            DefaultProjectedCRS modelCrs = new DefaultProjectedCRS("Sinusoidal", (GeographicCRS)base, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
            try {
                CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)modelCrs, imageBounds, transform);
                p.setGeoCoding((GeoCoding)geoCoding);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }
}

