/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.util.TimeUtils;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import ucar.nc2.NetcdfFile;

public class CfTimePart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile ncFile = ctx.getNetcdfFile();
        p.setStartTime(TimeUtils.getSceneRasterTime(ncFile, "start_date", "start_time"));
        p.setEndTime(TimeUtils.getSceneRasterTime(ncFile, "stop_date", "stop_time"));
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        ProductData.UTC utc = p.getStartTime();
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        if (utc != null) {
            writeable.addGlobalAttribute("start_date", utc.format());
        }
        if ((utc = p.getEndTime()) != null) {
            writeable.addGlobalAttribute("stop_date", utc.format());
        }
    }
}

