/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.cf;

import java.util.Locale;
import org.esa.beam.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfDescriptionPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfFlagCodingPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfMetadataPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfTiePointGridPart;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfTimePart;
import org.esa.beam.dataio.netcdf.util.RasterDigest;
import org.esa.beam.framework.dataio.DecodeQualification;
import ucar.nc2.NetcdfFile;

public class CfNetCdfReaderPlugIn
extends AbstractNetCdfReaderPlugIn {
    @Override
    public DecodeQualification getDecodeQualification(NetcdfFile netcdfFile) {
        RasterDigest rasterDigest = RasterDigest.createRasterDigest(netcdfFile.getRootGroup());
        if (rasterDigest != null && rasterDigest.getRasterVariables().length > 0) {
            return DecodeQualification.SUITABLE;
        }
        return DecodeQualification.UNABLE;
    }

    public String[] getFormatNames() {
        return new String[]{"NetCDF-CF"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc", ".nc.gz", ".grb", ".grb.gz"};
    }

    public String getDescription(Locale locale) {
        return "NetCDF following CF-Convention";
    }

    @Override
    public ProfileInitPartReader createInitialisationPartReader() {
        return new CfInitialisationPart();
    }

    @Override
    public ProfilePartReader createMetadataPartReader() {
        return new CfMetadataPart();
    }

    @Override
    public ProfilePartReader createBandPartReader() {
        return new CfBandPart();
    }

    @Override
    public ProfilePartReader createFlagCodingPartReader() {
        return new CfFlagCodingPart();
    }

    @Override
    public ProfilePartReader createGeoCodingPartReader() {
        return new CfGeocodingPart();
    }

    @Override
    public ProfilePartReader createTiePointGridPartReader() {
        return new CfTiePointGridPart();
    }

    @Override
    public ProfilePartReader createTimePartReader() {
        return new CfTimePart();
    }

    @Override
    public ProfilePartReader createDescriptionPartReader() {
        return new CfDescriptionPart();
    }
}

