/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Product;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;

public class BeamInitialisationPart
extends CfInitialisationPart {
    public static final String PRODUCT_TYPE = "product_type";

    @Override
    public Product readProductBody(ProfileReadContext ctx) throws ProductIOException {
        Dimension x = null;
        Dimension y = null;
        for (Dimension dimension : ctx.getNetcdfFile().getDimensions()) {
            String name = dimension.getName();
            if ("x".equalsIgnoreCase(name) || "lon".equalsIgnoreCase(name)) {
                x = dimension;
                continue;
            }
            if (!"y".equalsIgnoreCase(name) && !"lat".equalsIgnoreCase(name)) continue;
            y = dimension;
        }
        if (x == null || y == null) {
            throw new ProductIOException("Illegal Dimensions: Dimensions named (x,lon) and (y,lat) expected.");
        }
        return new Product((String)ctx.getProperty("productName"), this.readProductType(ctx), x.getLength(), y.getLength());
    }

    @Override
    public void writeProductBody(ProfileWriteContext ctx, Product p) throws IOException {
        super.writeProductBody(ctx, p);
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        writeable.addGlobalAttribute(PRODUCT_TYPE, p.getProductType());
        writeable.addGlobalAttribute("metadata_profile", "beam");
        writeable.addGlobalAttribute("metadata_version", "0.5");
    }

    @Override
    public String readProductType(ProfileReadContext ctx) {
        String pt;
        Attribute productTypeAtt = ctx.getNetcdfFile().findGlobalAttribute(PRODUCT_TYPE);
        if (productTypeAtt != null && (pt = productTypeAtt.getStringValue()) != null && pt.trim().length() > 0) {
            return pt.trim();
        }
        return super.readProductType(ctx);
    }
}

