/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfFlagCodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class BeamFlagCodingPart
extends ProfilePartIO {
    public static final String FLAG_DESCRIPTIONS = "flag_descriptions";
    public static final String FLAG_CODING_NAME = "flag_coding_name";
    public static final String DESCRIPTION_SEPARATOR = "\t";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Band[] bands;
        for (Band band : bands = p.getBands()) {
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            FlagCoding flagCoding = BeamFlagCodingPart.readFlagCoding(ctx, variableName);
            if (flagCoding == null) continue;
            p.getFlagCodingGroup().add((ProductNode)flagCoding);
            band.setSampleCoding((SampleCoding)flagCoding);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        Band[] bands;
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        for (Band band : bands = p.getBands()) {
            CfFlagCodingPart.writeFlagCoding(band, ncFile);
            this.writeFlagCoding(band, ncFile);
        }
    }

    public void writeFlagCoding(Band band, NFileWriteable ncFile) throws IOException {
        FlagCoding flagCoding = band.getFlagCoding();
        if (flagCoding != null) {
            String[] flagNames = flagCoding.getFlagNames();
            StringBuilder descriptions = new StringBuilder();
            for (String flagName : flagNames) {
                String description;
                MetadataAttribute flag = flagCoding.getFlag(flagName);
                if (flag != null && (description = flag.getDescription()) != null) {
                    descriptions.append(description);
                }
                descriptions.append(DESCRIPTION_SEPARATOR);
            }
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            ncFile.findVariable(variableName).addAttribute(FLAG_CODING_NAME, flagCoding.getName());
            ncFile.findVariable(variableName).addAttribute(FLAG_DESCRIPTIONS, descriptions.toString().trim());
        }
    }

    public static FlagCoding readFlagCoding(ProfileReadContext ctx, String variableName) {
        FlagCoding flagCoding = CfFlagCodingPart.readFlagCoding(ctx, variableName);
        if (flagCoding != null) {
            Attribute nameAtt;
            Variable variable = ctx.getNetcdfFile().getRootGroup().findVariable(variableName);
            Attribute descriptionsAtt = variable.findAttributeIgnoreCase(FLAG_DESCRIPTIONS);
            if (descriptionsAtt != null) {
                String[] descriptions = descriptionsAtt.getStringValue().split(DESCRIPTION_SEPARATOR);
                if (flagCoding.getNumAttributes() == descriptions.length) {
                    for (int i = 0; i < descriptions.length; ++i) {
                        flagCoding.getAttributeAt(i).setDescription(descriptions[i]);
                    }
                }
            }
            if ((nameAtt = variable.findAttributeIgnoreCase(FLAG_CODING_NAME)) != null) {
                flagCoding.setName(nameAtt.getStringValue());
            }
        }
        return flagCoding;
    }
}

