/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.dataio.netcdf.util.NetcdfMultiLevelImage;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelGeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamBandPart
extends ProfilePartIO {
    public static final String BANDWIDTH = "bandwidth";
    public static final String WAVELENGTH = "wavelength";
    public static final String VALID_PIXEL_EXPRESSION = "valid_pixel_expression";
    public static final String AUTO_GROUPING = "auto_grouping";
    public static final String QUICKLOOK_BAND_NAME = "quicklook_band_name";
    public static final String SOLAR_FLUX = "solar_flux";
    public static final String SPECTRAL_BAND_INDEX = "spectral_band_index";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        String quicklookBandName;
        Attribute quicklookBandNameAttribute;
        String autoGrouping;
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        List variables = netcdfFile.getVariables();
        for (Variable variable : variables) {
            List dimensions = variable.getDimensions();
            if (dimensions.size() != 2) continue;
            boolean yDimIndex = false;
            boolean xDimIndex = true;
            if (((ucar.nc2.Dimension)dimensions.get(0)).getLength() != p.getSceneRasterHeight() || ((ucar.nc2.Dimension)dimensions.get(1)).getLength() != p.getSceneRasterWidth()) continue;
            int rasterDataType = DataTypeUtils.getRasterDataType(variable);
            Band band = p.addBand(variable.getName(), rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)band);
            BeamBandPart.readBeamBandAttributes(variable, band);
            band.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)band, variable, ctx));
        }
        this.maybeApplySpectralIndexAndSolarFluxFromMetadata(p);
        Attribute autoGroupingAttribute = netcdfFile.findGlobalAttribute(AUTO_GROUPING);
        if (autoGroupingAttribute != null && (autoGrouping = autoGroupingAttribute.getStringValue()) != null) {
            p.setAutoGrouping(autoGrouping);
        }
        if ((quicklookBandNameAttribute = netcdfFile.findGlobalAttribute(QUICKLOOK_BAND_NAME)) != null && (quicklookBandName = quicklookBandNameAttribute.getStringValue()) != null) {
            p.setQuicklookBandName(quicklookBandName);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        String quicklookBandName;
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        String dimensions = ncFile.getDimensions();
        for (Band band : p.getBands()) {
            int dataType;
            if (this.isPixelGeoCodingBand(band)) continue;
            if (band.isLog10Scaled()) {
                dataType = band.getGeophysicalDataType();
                ctx.setProperty("convertLogScaledBands", true);
            } else {
                dataType = band.getDataType();
            }
            DataType ncDataType = DataTypeUtils.getNetcdfDataType(dataType);
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Dimension tileSize = ImageManager.getPreferredTileSize((Product)p);
            NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, dimensions);
            CfBandPart.writeCfBandAttributes((RasterDataNode)band, variable);
            BeamBandPart.writeBeamBandAttributes(band, variable);
        }
        Product.AutoGrouping autoGrouping = p.getAutoGrouping();
        if (autoGrouping != null) {
            ncFile.addGlobalAttribute(AUTO_GROUPING, autoGrouping.toString());
        }
        if ((quicklookBandName = p.getQuicklookBandName()) != null && !quicklookBandName.isEmpty()) {
            ncFile.addGlobalAttribute(QUICKLOOK_BAND_NAME, quicklookBandName);
        }
    }

    private boolean isPixelGeoCodingBand(Band band) {
        GeoCoding geoCoding = band.getGeoCoding();
        if (geoCoding instanceof PixelGeoCoding) {
            PixelGeoCoding pixelGeoCoding = (PixelGeoCoding)geoCoding;
            return pixelGeoCoding.getLatBand() == band || pixelGeoCoding.getLonBand() == band;
        }
        return false;
    }

    private static void readBeamBandAttributes(Variable variable, Band band) {
        Attribute attribute = variable.findAttribute(BANDWIDTH);
        if (attribute != null) {
            band.setSpectralBandwidth(attribute.getNumericValue().floatValue());
        }
        if ((attribute = variable.findAttribute(WAVELENGTH)) != null) {
            band.setSpectralWavelength(attribute.getNumericValue().floatValue());
        }
        if ((attribute = variable.findAttribute(SPECTRAL_BAND_INDEX)) != null) {
            band.setSpectralBandIndex(attribute.getNumericValue().intValue());
        }
        if ((attribute = variable.findAttribute(VALID_PIXEL_EXPRESSION)) != null) {
            band.setValidPixelExpression(attribute.getStringValue());
        }
        if ((attribute = variable.findAttribute(SOLAR_FLUX)) != null) {
            band.setSolarFlux(attribute.getNumericValue().floatValue());
        }
        band.setName(ReaderUtils.getRasterName(variable));
    }

    private void maybeApplySpectralIndexAndSolarFluxFromMetadata(Product p) {
        List<Band> bands = Arrays.asList(p.getBands());
        int spectralIndex = 0;
        for (Band band : bands) {
            boolean isSolarFluxSet;
            boolean isSpectralBandIndexSet;
            boolean isSpectralBand = band.getSpectralWavelength() != 0.0f;
            boolean bl = isSpectralBandIndexSet = band.getSpectralBandIndex() != -1;
            if (!isSpectralBand || isSpectralBandIndexSet) continue;
            band.setSpectralBandIndex(spectralIndex);
            boolean bl2 = isSolarFluxSet = band.getSolarFlux() != 0.0f;
            if (!isSolarFluxSet) {
                BeamBandPart.applySolarFluxFromMetadata(band, spectralIndex);
            }
            ++spectralIndex;
        }
    }

    private static void applySolarFluxFromMetadata(Band band, int spectralIndex) {
        MetadataElement metadataRoot = band.getProduct().getMetadataRoot();
        band.setSolarFlux(BeamBandPart.getSolarFluxFromMetadata(metadataRoot, spectralIndex));
    }

    private static float getSolarFluxFromMetadata(MetadataElement metadataRoot, int bandIndex) {
        MetadataAttribute sunSpecFlux;
        ProductData data;
        MetadataElement scalingFactorGads;
        if (metadataRoot != null && (scalingFactorGads = metadataRoot.getElement("Scaling_Factor_GADS")) != null && (data = (sunSpecFlux = scalingFactorGads.getAttribute("sun_spec_flux")).getData()).getNumElems() > bandIndex) {
            return data.getElemFloatAt(bandIndex);
        }
        return 0.0f;
    }

    public static void writeBeamBandAttributes(Band band, NVariable variable) throws IOException {
        float spectralBandIndex;
        float solarFlux;
        String validPixelExpression;
        float spectralWavelength;
        float spectralBandwidth = band.getSpectralBandwidth();
        if (spectralBandwidth > 0.0f) {
            variable.addAttribute(BANDWIDTH, Float.valueOf(spectralBandwidth));
        }
        if ((spectralWavelength = band.getSpectralWavelength()) > 0.0f) {
            variable.addAttribute(WAVELENGTH, Float.valueOf(spectralWavelength));
        }
        if ((validPixelExpression = band.getValidPixelExpression()) != null && validPixelExpression.trim().length() > 0) {
            variable.addAttribute(VALID_PIXEL_EXPRESSION, validPixelExpression);
        }
        if ((solarFlux = band.getSolarFlux()) > 0.0f) {
            variable.addAttribute(SOLAR_FLUX, Float.valueOf(solarFlux));
        }
        if ((spectralBandIndex = (float)band.getSpectralBandIndex()) >= 0.0f) {
            variable.addAttribute(SPECTRAL_BAND_INDEX, Float.valueOf(spectralBandIndex));
        }
        if (!band.getName().equals(variable.getName())) {
            variable.addAttribute("orig_name", band.getName());
        }
    }
}

