/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.esa.beam.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.beam.dataio.netcdf.NetCdfWriteProfile;
import org.esa.beam.dataio.netcdf.ProfileWriteContextImpl;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.dataio.AbstractProductWriter;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;

class DefaultNetCdfWriter
extends AbstractProductWriter {
    private HashMap<String, NVariable> variableMap = new HashMap();
    private NFileWriteable writeable;
    private boolean isYFlipped;
    private boolean convertLogScaledBands;

    DefaultNetCdfWriter(AbstractNetCdfWriterPlugIn writerPlugIn) {
        super((ProductWriterPlugIn)writerPlugIn);
    }

    public AbstractNetCdfWriterPlugIn getWriterPlugIn() {
        return (AbstractNetCdfWriterPlugIn)super.getWriterPlugIn();
    }

    protected void writeProductNodesImpl() throws IOException {
        Object convertLogScaledBandsProperty;
        AbstractNetCdfWriterPlugIn plugIn = this.getWriterPlugIn();
        this.writeable = plugIn.createWritable(this.getOutputString());
        NetCdfWriteProfile profile = new NetCdfWriteProfile();
        this.configureProfile(profile, plugIn);
        ProfileWriteContextImpl context = new ProfileWriteContextImpl(this.writeable);
        profile.writeProduct(context, this.getSourceProduct());
        Object yFlippedProperty = context.getProperty("yFlipped");
        if (yFlippedProperty instanceof Boolean) {
            this.isYFlipped = (Boolean)yFlippedProperty;
        }
        if ((convertLogScaledBandsProperty = context.getProperty("convertLogScaledBands")) instanceof Boolean) {
            this.convertLogScaledBands = (Boolean)convertLogScaledBandsProperty;
        }
    }

    public void configureProfile(NetCdfWriteProfile profile, AbstractNetCdfWriterPlugIn plugIn) throws IOException {
        profile.setInitialisationPartWriter(plugIn.createInitialisationPartWriter());
        profile.addProfilePartWriter(plugIn.createMetadataPartWriter());
        profile.addProfilePartWriter(plugIn.createBandPartWriter());
        profile.addProfilePartWriter(plugIn.createTiePointGridPartWriter());
        profile.addProfilePartWriter(plugIn.createFlagCodingPartWriter());
        profile.addProfilePartWriter(plugIn.createGeoCodingPartWriter());
        profile.addProfilePartWriter(plugIn.createImageInfoPartWriter());
        profile.addProfilePartWriter(plugIn.createIndexCodingPartWriter());
        profile.addProfilePartWriter(plugIn.createMaskPartWriter());
        profile.addProfilePartWriter(plugIn.createStxPartWriter());
        profile.addProfilePartWriter(plugIn.createTimePartWriter());
        profile.addProfilePartWriter(plugIn.createDescriptionPartWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        String variableName = ReaderUtils.getVariableName((RasterDataNode)sourceBand);
        if (this.shallWriteVariable(variableName)) {
            ProductData scaledBuffer;
            if (this.convertLogScaledBands && sourceBand.isLog10Scaled()) {
                scaledBuffer = ProductData.createInstance((int)30, (int)sourceBuffer.getNumElems());
                for (int i = 0; i < sourceBuffer.getNumElems(); ++i) {
                    double elemDoubleAt = sourceBuffer.getElemDoubleAt(i);
                    scaledBuffer.setElemDoubleAt(i, sourceBand.scale(elemDoubleAt));
                }
            } else {
                scaledBuffer = sourceBuffer;
            }
            NFileWriteable nFileWriteable = this.writeable;
            synchronized (nFileWriteable) {
                NVariable variable = this.getVariable(variableName);
                variable.write(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, this.isYFlipped, scaledBuffer);
            }
        }
    }

    private boolean shallWriteVariable(String variableName) {
        NVariable variable = this.writeable.findVariable(variableName);
        return variable != null;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.writeable != null) {
            this.writeable.close();
            this.writeable = null;
        }
        if (this.variableMap != null) {
            this.variableMap.clear();
            this.variableMap = null;
        }
    }

    public void deleteOutput() throws IOException {
        this.close();
        this.getOutputFile().delete();
    }

    private synchronized NVariable getVariable(String variableName) throws ProductIOException {
        NVariable variable = this.variableMap.get(variableName);
        if (variable == null) {
            variable = this.writeable.findVariable(variableName);
            if (variable == null) {
                throw new ProductIOException("Nc raster data variable '" + variableName + "' not found");
            }
            this.variableMap.put(variableName, variable);
        }
        return variable;
    }

    private File getOutputFile() {
        return new File(this.getOutputString());
    }

    private String getOutputString() {
        return String.valueOf(this.getOutput());
    }
}

