/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.dataio.netcdf.DefaultNetCdfReader;
import org.esa.beam.dataio.netcdf.NullProfilePartReader;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.beam.dataio.netcdf.util.RasterDigest;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.util.io.BeamFileFilter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public abstract class AbstractNetCdfReaderPlugIn
implements ProductReaderPlugIn {
    public final Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DecodeQualification getDecodeQualification(Object input) {
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)input.toString());
            DecodeQualification decodeQualification = this.getDecodeQualification(netcdfFile);
            return decodeQualification;
        }
        catch (Throwable ignored) {
        }
        finally {
            try {
                if (netcdfFile != null) {
                    netcdfFile.close();
                }
            }
            catch (IOException ignore) {}
        }
        return DecodeQualification.UNABLE;
    }

    public ProductReader createReaderInstance() {
        return new DefaultNetCdfReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    protected void initReadContext(ProfileReadContext ctx) throws IOException {
        RasterDigest rasterDigest;
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        Group rootGroup = netcdfFile.getRootGroup();
        if (ctx.getProperty("subset") != null) {
            ProductSubsetDef subset = (ProductSubsetDef)ctx.getProperty("subset");
            List variables = rootGroup.getVariables();
            ArrayList<String> variablesTobeDeleted = new ArrayList<String>();
            for (Variable variable : variables) {
                if (subset.isNodeAccepted(variable.getName())) continue;
                variablesTobeDeleted.add(variable.getShortName());
            }
            for (String variableName : variablesTobeDeleted) {
                rootGroup.removeVariable(variableName);
            }
        }
        if ((rasterDigest = RasterDigest.createRasterDigest(rootGroup)) == null) {
            throw new IOException("File does not contain any bands.");
        }
        ctx.setRasterDigest(rasterDigest);
    }

    protected abstract DecodeQualification getDecodeQualification(NetcdfFile var1);

    public abstract ProfileInitPartReader createInitialisationPartReader();

    public ProfilePartReader createMetadataPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createBandPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createFlagCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createGeoCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createImageInfoPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createIndexCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createMaskPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createStxPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createTiePointGridPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createTimePartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createDescriptionPartReader() {
        return new NullProfilePartReader();
    }
}

