/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis.netcdf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.esa.beam.dataio.modis.netcdf.NetCDFAttributes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import ucar.nc2.Attribute;

public class NetCDFAttributesTest {
    private NetCDFAttributes netCDFAttributes;

    @Test
    public void testAddList_emptyList() {
        ArrayList globalAttributes = new ArrayList();
        this.netCDFAttributes.add(globalAttributes);
        Assert.assertNull((Object)this.netCDFAttributes.get("egal_was"));
    }

    @Test
    public void testAddList_nullList() {
        this.netCDFAttributes.add(null);
        Assert.assertNull((Object)this.netCDFAttributes.get("egal_was"));
    }

    @Test
    public void testAddList() {
        ArrayList<Attribute> globalAttributes = new ArrayList<Attribute>();
        globalAttributes.add(new Attribute("a_attrib", (Number)12));
        globalAttributes.add(new Attribute("b_attrib", (Number)13));
        globalAttributes.add(new Attribute("c_attrib", (Number)14));
        this.netCDFAttributes.add(globalAttributes);
        Attribute attrib = this.netCDFAttributes.get("a_attrib");
        Assert.assertNotNull((Object)attrib);
        Assert.assertEquals((long)12L, (long)attrib.getNumericValue().intValue());
        attrib = this.netCDFAttributes.get("c_attrib");
        Assert.assertNotNull((Object)attrib);
        Assert.assertEquals((long)14L, (long)attrib.getNumericValue().intValue());
        attrib = this.netCDFAttributes.get("egal_was");
        Assert.assertNull((Object)attrib);
    }

    @Test
    public void testGetAll() {
        ArrayList<Attribute> globalAttributes = new ArrayList<Attribute>();
        globalAttributes.add(new Attribute("one_attrib", (Number)1));
        globalAttributes.add(new Attribute("two_attrib", (Number)2));
        this.netCDFAttributes.add(globalAttributes);
        Attribute[] result = this.netCDFAttributes.getAll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        List<Attribute> resultList = Arrays.asList(result);
        resultList.contains(new Attribute("one_attrib", (Number)1));
        resultList.contains(new Attribute("two_attrib", (Number)2));
    }

    @Before
    public void setUp() throws Exception {
        this.netCDFAttributes = new NetCDFAttributes();
    }
}

