/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis.attribute;

import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisGlobalAttributes;
import org.esa.beam.dataio.modis.attribute.DaacAttributes;
import org.esa.beam.dataio.modis.netcdf.NetCDFVariables;
import ucar.nc2.Dimension;

public class DaacAttributesTest
extends TestCase {
    public void testInheritance() {
        DaacAttributes daacAttributes = new DaacAttributes(new NetCDFVariables());
        DaacAttributesTest.assertTrue((boolean)(daacAttributes instanceof ModisGlobalAttributes));
    }

    public void testIsImappFormat() {
        DaacAttributes daacAttributes = new DaacAttributes(new NetCDFVariables());
        DaacAttributesTest.assertFalse((boolean)daacAttributes.isImappFormat());
    }

    public void testIsWidthDimension() {
        Dimension dimension = new Dimension("Max_EV_frames", 34);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("MODIS_Grid_16DAY_1km_VI/Data Fields/XDim", 34);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("Swath/Data Fields/Number_of_samples_per_record", 34);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("ist_quatsch", 34);
        DaacAttributesTest.assertFalse((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
    }

    public void testIsHeightDimension() {
        Dimension dimension = new Dimension("10*nscans", 838);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("20*nscans", 838);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("MODIS_Grid_16DAY_1km_VI/Data Fields/YDim", 838);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("Swath/Data Fields/Number_of_records", 838);
        DaacAttributesTest.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("ausgedacht", 838);
        DaacAttributesTest.assertFalse((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
    }
}

