/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisUtils;

public class ModisUtilsTest_CreateDateFromString
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testOk_MoreThanMillisecondsSnipped() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2004-07-10";
        String time = "21:55:11.123456";
        Date testDate = ModisUtils.createDateFromStrings((String)"2004-07-10", (String)"21:55:11.123456");
        ModisUtilsTest_CreateDateFromString.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2004, (int)cal.get(1));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)6, (int)cal.get(2));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)10, (int)cal.get(5));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)21, (int)cal.get(11));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)55, (int)cal.get(12));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)11, (int)cal.get(13));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)123, (int)cal.get(14));
    }

    public void testOk_exact() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2005-08-22";
        String time = "12:22:09.887";
        Date testDate = ModisUtils.createDateFromStrings((String)"2005-08-22", (String)"12:22:09.887");
        ModisUtilsTest_CreateDateFromString.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2005, (int)cal.get(1));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)7, (int)cal.get(2));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)22, (int)cal.get(5));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)12, (int)cal.get(11));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)22, (int)cal.get(12));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)9, (int)cal.get(13));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)887, (int)cal.get(14));
    }

    public void testOk_WithoutMilliseconds() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2007-03-25";
        String time = "15:16:17";
        Date testDate = ModisUtils.createDateFromStrings((String)"2007-03-25", (String)"15:16:17");
        ModisUtilsTest_CreateDateFromString.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2007, (int)cal.get(1));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2, (int)cal.get(2));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)25, (int)cal.get(5));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)15, (int)cal.get(11));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)16, (int)cal.get(12));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)17, (int)cal.get(13));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)0, (int)cal.get(14));
    }

    public void testOk_WithMillisecondsFragment() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2001-09-13";
        String time = "07:08:09.4";
        Date testDate = ModisUtils.createDateFromStrings((String)"2001-09-13", (String)"07:08:09.4");
        ModisUtilsTest_CreateDateFromString.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2001, (int)cal.get(1));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)8, (int)cal.get(2));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)13, (int)cal.get(5));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)7, (int)cal.get(11));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)8, (int)cal.get(12));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)9, (int)cal.get(13));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)400, (int)cal.get(14));
    }

    public void testOk_WithoutSeconds() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2008-04-21";
        String time = "17:18";
        Date testDate = ModisUtils.createDateFromStrings((String)"2008-04-21", (String)"17:18");
        ModisUtilsTest_CreateDateFromString.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        ModisUtilsTest_CreateDateFromString.assertEquals((int)2008, (int)cal.get(1));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)3, (int)cal.get(2));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)21, (int)cal.get(5));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)17, (int)cal.get(11));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)18, (int)cal.get(12));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)0, (int)cal.get(13));
        ModisUtilsTest_CreateDateFromString.assertEquals((int)0, (int)cal.get(14));
    }
}

