/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import junit.framework.TestCase;
import org.esa.beam.dataio.modis.IncrementOffset;
import org.esa.beam.dataio.modis.ModisUtils;
import org.esa.beam.util.math.Range;

public class ModisUtilsTest
extends TestCase {
    private static final String TestCoreString = "GROUP                  = INVENTORYMETADATA\n  GROUPTYPE            = MASTERGROUP\n\n  GROUP                  = ECSDATAGRANULE\n\n    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"MYD021KM.A2005297.2205.005.2005299100720.hdf\"\n    END_OBJECT             = LOCALGRANULEID\n\n    OBJECT                 = PRODUCTIONDATETIME\n      NUM_VAL              = 1\n      VALUE                = \"2005-10-26T10:07:21.000Z\"\n    END_OBJECT             = PRODUCTIONDATETIME\n\n    OBJECT                 = DAYNIGHTFLAG\n      NUM_VAL              = 1\n      VALUE                = \"Night\"\n    END_OBJECT             = DAYNIGHTFLAG\nEND_GROUP              = ADDITIONALATTRIBUTES\nGROUP                  = ORBITCALCULATEDSPATIALDOMAIN\n   OBJECT                 = ORBITNUMBER\n       CLASS                = \"1\"\n       NUM_VAL              = 1\n       VALUE                = 18490\n   END_OBJECT           = ORBITNUMBER\nEND_GROUP              = ORBITCALCULATEDSPATIALDOMAIN\n\nEND_GROUP              = INVENTORYMETADATA\n\nEND";

    public void testExtractValueForKey() {
        ModisUtilsTest.assertEquals((String)"Night", (String)ModisUtils.extractValueForKey((String)TestCoreString, (String)"DAYNIGHTFLAG"));
        ModisUtilsTest.assertEquals((String)"2005-10-26T10:07:21.000Z", (String)ModisUtils.extractValueForKey((String)TestCoreString, (String)"PRODUCTIONDATETIME"));
        ModisUtilsTest.assertNull((Object)ModisUtils.extractValueForKey((String)TestCoreString, (String)"huppepup"));
    }

    public void testExtractIntegerValueFromObject() {
        ModisUtilsTest.assertEquals((String)"18490", (String)ModisUtils.extractValueForKey((String)TestCoreString, (String)"ORBITNUMBER"));
    }

    public void testExtractValueForKeyHandlesStupidInput() {
        try {
            ModisUtils.extractValueForKey(null, (String)"DAYNIGHTFLAG");
            ModisUtilsTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ModisUtils.extractValueForKey((String)TestCoreString, null);
            ModisUtilsTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetIncrementOffset() {
        String test1 = "3,8";
        String test2 = "3,8,13,...";
        IncrementOffset incrementOffset = ModisUtils.getIncrementOffset((String)"3,8");
        ModisUtilsTest.assertNotNull((Object)incrementOffset);
        ModisUtilsTest.assertEquals((int)2, (int)incrementOffset.offset);
        ModisUtilsTest.assertEquals((int)5, (int)incrementOffset.increment);
        incrementOffset = ModisUtils.getIncrementOffset((String)"3,8,13,...");
        ModisUtilsTest.assertNotNull((Object)incrementOffset);
        ModisUtilsTest.assertEquals((int)2, (int)incrementOffset.offset);
        ModisUtilsTest.assertEquals((int)5, (int)incrementOffset.increment);
    }

    public void testGetRangeFromString() {
        String test_1 = "0, 32767";
        String test_2 = "6,2";
        Range result = ModisUtils.getRangeFromString((String)"0, 32767");
        ModisUtilsTest.assertNotNull((Object)result);
        ModisUtilsTest.assertEquals((int)0, (int)((int)result.getMin()));
        ModisUtilsTest.assertEquals((int)Short.MAX_VALUE, (int)((int)result.getMax()));
        result = ModisUtils.getRangeFromString((String)"6,2");
        ModisUtilsTest.assertNotNull((Object)result);
        ModisUtilsTest.assertEquals((int)2, (int)((int)result.getMin()));
        ModisUtilsTest.assertEquals((int)6, (int)((int)result.getMax()));
    }

    public void testExtractBandName() {
        ModisUtilsTest.assertEquals((String)"band_name", (String)ModisUtils.extractBandName((String)"band_name"));
        ModisUtilsTest.assertEquals((String)"EV_250_Aggr500_RefSB", (String)ModisUtils.extractBandName((String)"MODIS_SWATH_Type_L1B/Data Fields/EV_250_Aggr500_RefSB"));
        ModisUtilsTest.assertEquals((String)"EV_500_RefSB_Uncert_Indexes", (String)ModisUtils.extractBandName((String)"MODIS_SWATH_Type_L1B/Data Fields/EV_500_RefSB_Uncert_Indexes"));
    }

    public void testDecodeBandName() {
        ModisUtilsTest.assertEquals((String)".bla", (String)ModisUtils.decodeBandName((String)"schnipp,schnupp,bla,blubb", (int)2));
        ModisUtilsTest.assertEquals((String)".schnipp", (String)ModisUtils.decodeBandName((String)"schnipp,schnupp,bla,blubb", (int)0));
    }
}

