/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import java.awt.Rectangle;
import org.esa.beam.dataio.modis.ModisTiePointGeoCoding;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.junit.Assert;
import org.junit.Test;

public class ModisTiePointGeoCodingTest {
    @Test
    public void testMustRecalculateGeoCoding() {
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        Assert.assertFalse((boolean)ModisTiePointGeoCoding.mustRecalculateTiePointGrids(null));
        Assert.assertFalse((boolean)ModisTiePointGeoCoding.mustRecalculateTiePointGrids((ProductSubsetDef)subsetDef));
        subsetDef.setRegion(new Rectangle(0, 3, 4, 5));
        Assert.assertTrue((boolean)ModisTiePointGeoCoding.mustRecalculateTiePointGrids((ProductSubsetDef)subsetDef));
    }

    @Test
    public void testIfModisProductIsHighResolutionProduct() {
        Assert.assertTrue((boolean)ModisTiePointGeoCoding.isHighResolution((int)120, (int)60));
        Assert.assertTrue((boolean)ModisTiePointGeoCoding.isHighResolution((int)3072, (int)1536));
        Assert.assertFalse((boolean)ModisTiePointGeoCoding.isHighResolution((int)120, (int)24));
        Assert.assertFalse((boolean)ModisTiePointGeoCoding.isHighResolution((int)2072, (int)208));
    }

    @Test
    public void testCalculateStartLine() {
        Assert.assertEquals((long)100L, (long)ModisTiePointGeoCoding.calculateStartLine((int)20, (Rectangle)new Rectangle(0, 106, 10, 10)));
        Assert.assertEquals((long)1210L, (long)ModisTiePointGeoCoding.calculateStartLine((int)10, (Rectangle)new Rectangle(0, 1217, 10, 10)));
    }

    @Test
    public void testCalculateStopLine() {
        Assert.assertEquals((long)120L, (long)ModisTiePointGeoCoding.calculateStopLine((int)20, (Rectangle)new Rectangle(0, 106, 10, 10)));
        Assert.assertEquals((long)1230L, (long)ModisTiePointGeoCoding.calculateStopLine((int)10, (Rectangle)new Rectangle(0, 1217, 10, 10)));
    }
}

