/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisProductReader;
import org.esa.beam.dataio.modis.ModisProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.util.io.BeamFileFilter;

public class ModisProductReaderPluginTest
extends TestCase {
    private ModisProductReaderPlugIn plugIn;
    private File testFile;

    public void testInputTypes() {
        Class[] inputTypes = this.plugIn.getInputTypes();
        ModisProductReaderPluginTest.assertNotNull((Object)inputTypes);
        ModisProductReaderPluginTest.assertEquals((int)2, (int)inputTypes.length);
        ModisProductReaderPluginTest.assertEquals(String.class, (Object)inputTypes[0]);
        ModisProductReaderPluginTest.assertEquals(File.class, (Object)inputTypes[1]);
    }

    public void testCreateReaderInstance() {
        ProductReader readerInstance = this.plugIn.createReaderInstance();
        ModisProductReaderPluginTest.assertNotNull((Object)readerInstance);
        ModisProductReaderPluginTest.assertTrue((boolean)(readerInstance instanceof ModisProductReader));
    }

    public void testGetDefaultFileExtension() {
        String[] defaultFileExtensions = this.plugIn.getDefaultFileExtensions();
        ModisProductReaderPluginTest.assertNotNull((Object)defaultFileExtensions);
        ModisProductReaderPluginTest.assertEquals((int)1, (int)defaultFileExtensions.length);
        ModisProductReaderPluginTest.assertEquals((String)".hdf", (String)defaultFileExtensions[0]);
    }

    public void testGetDescription() {
        String description = this.plugIn.getDescription(Locale.getDefault());
        ModisProductReaderPluginTest.assertNotNull((Object)description);
        ModisProductReaderPluginTest.assertEquals((String)"MODIS HDF4 Data Products", (String)description);
        description = this.plugIn.getDescription(null);
        ModisProductReaderPluginTest.assertNotNull((Object)description);
        ModisProductReaderPluginTest.assertEquals((String)"MODIS HDF4 Data Products", (String)description);
    }

    public void testGetFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        ModisProductReaderPluginTest.assertNotNull((Object)formatNames);
        ModisProductReaderPluginTest.assertEquals((int)1, (int)formatNames.length);
        ModisProductReaderPluginTest.assertEquals((String)"MODIS", (String)formatNames[0]);
    }

    public void testGetInputFile_nullInput() {
        File file = ModisProductReaderPlugIn.getInputFile(null);
        ModisProductReaderPluginTest.assertNull((Object)file);
    }

    public void testGetInputFile_stringInput() {
        String testFileName = "test.file";
        File file = ModisProductReaderPlugIn.getInputFile((Object)testFileName);
        ModisProductReaderPluginTest.assertNotNull((Object)file);
        ModisProductReaderPluginTest.assertEquals((String)testFileName, (String)file.getName());
    }

    public void testGetInputFile_fileInput() {
        File inputFile = new File("I_am_a.file");
        File file = ModisProductReaderPlugIn.getInputFile((Object)inputFile);
        ModisProductReaderPluginTest.assertNotNull((Object)file);
        ModisProductReaderPluginTest.assertEquals((String)inputFile.getName(), (String)file.getName());
    }

    public void testHasHdfFileExtension() {
        ModisProductReaderPluginTest.assertFalse((boolean)ModisProductReaderPlugIn.hasHdfFileExtension(null));
        ModisProductReaderPluginTest.assertFalse((boolean)ModisProductReaderPlugIn.hasHdfFileExtension((File)new File("tonio_und.tom")));
        ModisProductReaderPluginTest.assertTrue((boolean)ModisProductReaderPlugIn.hasHdfFileExtension((File)new File("I_am_but.hdf")));
    }

    public void testGetProductFileFilter() {
        BeamFileFilter productFileFilter = this.plugIn.getProductFileFilter();
        ModisProductReaderPluginTest.assertNotNull((Object)productFileFilter);
        ModisProductReaderPluginTest.assertEquals((String)"MODIS", (String)productFileFilter.getFormatName());
        ModisProductReaderPluginTest.assertEquals((String)".hdf", (String)productFileFilter.getDefaultExtension());
        ModisProductReaderPluginTest.assertEquals((String)"MODIS HDF4 Data Products (*.hdf)", (String)productFileFilter.getDescription());
    }

    public void testIsValidInputFile_nullFile() {
        ModisProductReaderPluginTest.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile(null));
    }

    public void testIsValidInputFile_notExistingFile() {
        ModisProductReaderPluginTest.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile((File)new File("I/don/not/exist.hdf")));
    }

    public void testIsValidInputFile_nonHdfFile() throws IOException {
        this.testFile = new File("I_do_exist.txt");
        if (!this.testFile.createNewFile()) {
            ModisProductReaderPluginTest.fail((String)"unable to create TestFile");
        }
        ModisProductReaderPluginTest.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile((File)this.testFile));
    }

    public void testIsValidInputFile_hdfFile() throws IOException {
        this.testFile = new File("I_do_exist.hdf");
        if (!this.testFile.createNewFile()) {
            ModisProductReaderPluginTest.fail((String)"unable to create TestFile");
        }
        ModisProductReaderPluginTest.assertTrue((boolean)ModisProductReaderPlugIn.isValidInputFile((File)this.testFile));
    }

    protected void setUp() {
        this.plugIn = new ModisProductReaderPlugIn();
    }

    protected void tearDown() throws Exception {
        if (this.testFile != null && !this.testFile.delete()) {
            ModisProductReaderPluginTest.fail((String)"unable to delete test file");
        }
    }
}

