/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisFileReader;
import org.esa.beam.dataio.modis.ModisGlobalAttributes;
import org.esa.beam.dataio.modis.hdf.HdfDataField;
import org.esa.beam.dataio.modis.productdb.ModisBandDescription;
import org.esa.beam.dataio.modis.productdb.ModisSpectralInfo;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.math.Range;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ModisFileReaderTest
extends TestCase {
    public void testGetTypeString_typeNull() {
        Product product = new Product("Name", "PROD_TYPE", 5, 5);
        ModisFileReaderTest.assertEquals((String)"PROD_TYPE", (String)ModisFileReader.getTypeString(null, (Product)product));
    }

    public void testGetTypeString_typeSupplied() {
        Product product = new Product("Name", "PROD_TYPE", 5, 5);
        ModisFileReaderTest.assertEquals((String)"TYPE_STRING", (String)ModisFileReader.getTypeString((String)"TYPE_STRING", (Product)product));
    }

    public void testCreateRangeFromArray_nullArray() {
        Range range = ModisFileReader.createRangeFromArray(null);
        ModisFileReaderTest.assertNull((Object)range);
    }

    public void testCreateRangeFromArray_tooShortArray() {
        Range range = ModisFileReader.createRangeFromArray((int[])new int[]{34});
        ModisFileReaderTest.assertNull((Object)range);
    }

    public void testCreateRangeFromArray_orderedInts() {
        Range range = ModisFileReader.createRangeFromArray((int[])new int[]{34, 3809});
        ModisFileReaderTest.assertNotNull((Object)range);
        ModisFileReaderTest.assertEquals((double)34.0, (double)range.getMin(), (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)3809.0, (double)range.getMax(), (double)1.0E-8);
    }

    public void testCreateRangeFromArray_inverseOrderedInts() {
        Range range = ModisFileReader.createRangeFromArray((int[])new int[]{9886, 14});
        ModisFileReaderTest.assertNotNull((Object)range);
        ModisFileReaderTest.assertEquals((double)14.0, (double)range.getMin(), (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)9886.0, (double)range.getMax(), (double)1.0E-8);
    }

    public void testHasInvalidScaleAndOffset_invalidScale() {
        ModisFileReaderTest.assertTrue((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[2], (float[])new float[4], (int)3));
    }

    public void testHasInvalidScaleAndOffset_invalidOffset() {
        ModisFileReaderTest.assertTrue((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[4], (float[])new float[2], (int)3));
    }

    public void testHasInvalidScaleAndOffset() {
        ModisFileReaderTest.assertFalse((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[4], (float[])new float[4], (int)3));
    }

    public void testSetSpectralBandInfo_notSpectral() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "false", "", "", "", "", "", "");
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"", (Band)band);
        ModisFileReaderTest.assertEquals((int)-1, (int)band.getSpectralBandIndex());
        ModisFileReaderTest.assertEquals((double)0.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)0.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    public void testSetSpectralBandInfo_fromBandIndex() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "true", "", "", "", "", "", "");
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"4", (Band)band);
        ModisFileReaderTest.assertEquals((int)6, (int)band.getSpectralBandIndex());
        ModisFileReaderTest.assertEquals((double)555.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)20.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    public void testSetSpectralBandInfo_fromSpecInfo() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "true", "", "", "", "", "", "");
        ModisSpectralInfo spectralInfo = new ModisSpectralInfo("2", "3", "4");
        description.setSpecInfo(spectralInfo);
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"", (Band)band);
        ModisFileReaderTest.assertEquals((int)4, (int)band.getSpectralBandIndex());
        ModisFileReaderTest.assertEquals((double)2.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)3.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    public void testIsEosGridType() throws IOException {
        TestGlobalAttributes globalAttributes = new TestGlobalAttributes();
        globalAttributes.setEosType("EOS_TYPE_GRID");
        ModisFileReaderTest.assertTrue((boolean)ModisFileReader.isEosGridType((ModisGlobalAttributes)globalAttributes));
        globalAttributes.setEosType("EOS_invalid_and_ausgedacht");
        ModisFileReaderTest.assertFalse((boolean)ModisFileReader.isEosGridType((ModisGlobalAttributes)globalAttributes));
    }

    public void testInvert() {
        float[] scales = new float[]{24.7f, 0.0f, -100.0f};
        ModisFileReader.invert((float[])scales);
        ModisFileReaderTest.assertEquals((double)0.04048582911491394, (double)scales[0], (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)0.0, (double)scales[1], (double)1.0E-8);
        ModisFileReaderTest.assertEquals((double)-0.01f, (double)scales[2], (double)1.0E-8);
    }

    class TestGlobalAttributes
    implements ModisGlobalAttributes {
        private String eosType;

        TestGlobalAttributes() {
        }

        public String getProductName() throws IOException {
            throw new NotImplementedException();
        }

        public String getProductType() throws IOException {
            throw new NotImplementedException();
        }

        public Dimension getProductDimensions(List<ucar.nc2.Dimension> netcdfFileDimensions) {
            throw new NotImplementedException();
        }

        public HdfDataField getDatafield(String name) throws ProductIOException {
            throw new NotImplementedException();
        }

        public Date getSensingStart() {
            throw new NotImplementedException();
        }

        public Date getSensingStop() {
            throw new NotImplementedException();
        }

        public int[] getSubsamplingAndOffset(String dimensionName) {
            throw new NotImplementedException();
        }

        public boolean isImappFormat() {
            throw new NotImplementedException();
        }

        public String getEosType() {
            return this.eosType;
        }

        public void setEosType(String eosType) {
            this.eosType = eosType;
        }

        public GeoCoding createGeocoding() {
            throw new NotImplementedException();
        }
    }
}

