/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisDaacUtils;
import org.esa.beam.dataio.modis.productdb.ModisProductDb;
import org.esa.beam.framework.dataio.ProductIOException;

public class ModisDaacUtilsTest_extractProductType
extends TestCase {
    public void testOk_MOD13A2_InTheMiddle() throws ProductIOException {
        String typeString = ModisDaacUtils.extractProductType((String)"MOD_SS.MOD13A2.somthing other");
        ModisDaacUtilsTest_extractProductType.assertEquals((String)"MOD13A2", (String)typeString);
    }

    public void testOk_MYD13A2_AtStart() throws ProductIOException {
        String typeString = ModisDaacUtils.extractProductType((String)"MYD13A2.somthing other");
        ModisDaacUtilsTest_extractProductType.assertEquals((String)"MYD13A2", (String)typeString);
    }

    public void testAllProductTypes_InTheMiddle() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = "anyPrefix." + type + ".anySuffix";
            ModisDaacUtilsTest_extractProductType.assertEquals((String)("Index = " + i), (String)ModisDaacUtils.extractProductType((String)toTest), (String)type);
        }
    }

    public void testAllProductTypes_AtStart() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = type + ".anySuffix";
            ModisDaacUtilsTest_extractProductType.assertEquals((String)("Index = " + i), (String)ModisDaacUtils.extractProductType((String)toTest), (String)type);
        }
    }

    public void testShittyEsaNotFollowingTheConventionsNameHandling() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = type + "_anySuffix";
            if (this.isImapp(toTest)) continue;
            ModisDaacUtilsTest_extractProductType.assertEquals((String)("Index = " + i), (String)ModisDaacUtils.extractProductType((String)toTest), (String)type);
        }
    }

    public void testExtractProdcutTypeReturnsEmptyStringOnUnknown() throws ProductIOException {
        ModisDaacUtilsTest_extractProductType.assertEquals((String)"", (String)ModisDaacUtils.extractProductType((String)"This.is.an.invalid.type"));
        ModisDaacUtilsTest_extractProductType.assertEquals((String)"", (String)ModisDaacUtils.extractProductType((String)"This_is_an_invalid_type"));
    }

    private boolean isImapp(String toTest) {
        return toTest.indexOf("IMAPP") != -1;
    }
}

