/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import junit.framework.TestCase;
import org.esa.beam.dataio.modis.ModisDaacUtils;

public class ModisDaacUtilsTest_correctAmpersandWrap
extends TestCase {
    public void testStandardString() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)" any\n standard\r String\n\r without & wrap  ");
        ModisDaacUtilsTest_correctAmpersandWrap.assertEquals((String)" any\n standard\r String\n\r without & wrap  ", (String)corrected);
    }

    public void testAmpersandWithoutWrap() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"   dkjhaf & da\n   lsmf\n");
        ModisDaacUtilsTest_correctAmpersandWrap.assertEquals((String)"   dkjhaf & da\n   lsmf\n", (String)corrected);
    }

    public void testAmpersandWithWrap() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"   FistPartAnd&\n   SecondPart");
        ModisDaacUtilsTest_correctAmpersandWrap.assertEquals((String)"   FistPartAndSecondPart", (String)corrected);
    }

    public void testLeaveSpecialCharactersUnchanged() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"\u00df\u00c4\u00d6\u00dc?#~@|<>\u20ac\u00b5}][{");
        ModisDaacUtilsTest_correctAmpersandWrap.assertEquals((String)"\u00df\u00c4\u00d6\u00dc?#~@|<>\u20ac\u00b5}][{", (String)corrected);
    }

    public void testConcrete() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"/mnt/juggle//TERRA/MOD_SS.MOD13A2.A2000&\n          049.cs_bartonbe.005.2006257073624.hdf\"\n    END_OBJECT             = LOCALGRANULEID");
        ModisDaacUtilsTest_correctAmpersandWrap.assertEquals((String)"    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"/mnt/juggle//TERRA/MOD_SS.MOD13A2.A2000049.cs_bartonbe.005.2006257073624.hdf\"\n    END_OBJECT             = LOCALGRANULEID", (String)corrected);
    }
}

