/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.modis;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.dataio.modis.ModisConstants;

public class ModisConstantsTest
extends TestCase {
    private static float[] expWavelength = new float[]{645.0f, 858.5f, 469.0f, 555.0f, 1240.0f, 1640.0f, 2130.0f, 412.5f, 443.0f, 488.0f, 531.0f, 551.0f, 667.0f, 678.0f, 748.0f, 869.5f, 905.0f, 936.0f, 940.0f, 3750.0f, 3959.0f, 3959.0f, 4050.0f, 4465.5f, 4515.5f, 1375.0f, 6715.0f, 7325.0f, 8550.0f, 9730.0f, 11030.0f, 12020.0f, 13335.0f, 13635.0f, 13935.0f, 14235.0f};
    private static float[] expBandwidth = new float[]{50.0f, 35.0f, 20.0f, 20.0f, 20.0f, 24.0f, 50.0f, 15.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 15.0f, 30.0f, 10.0f, 50.0f, 180.0f, 60.0f, 60.0f, 60.0f, 65.0f, 67.0f, 30.0f, 360.0f, 300.0f, 300.0f, 300.0f, 500.0f, 500.0f, 300.0f, 300.0f, 300.0f, 300.0f};

    public ModisConstantsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ModisConstantsTest.class);
    }

    public void testFilePropertyConstants() {
        ModisConstantsTest.assertEquals((String)".hdf", (String)".hdf");
        ModisConstantsTest.assertEquals((String)"MODIS HDF4 Data Products", (String)"MODIS HDF4 Data Products");
        ModisConstantsTest.assertEquals((String)"MODIS", (String)"MODIS");
    }

    public void testMetadataKeyConstants() {
        ModisConstantsTest.assertEquals((String)"Number of Day mode scans", (String)"Number of Day mode scans");
        ModisConstantsTest.assertEquals((String)"Number of Night mode scans", (String)"Number of Night mode scans");
        ModisConstantsTest.assertEquals((String)"CoreMetadata\\.0", (String)"CoreMetadata\\.0");
        ModisConstantsTest.assertEquals((String)"StructMetadata\\.0", (String)"StructMetadata\\.0");
        ModisConstantsTest.assertEquals((String)"GROUP", (String)"GROUP");
        ModisConstantsTest.assertEquals((String)"END_GROUP", (String)"END_GROUP");
        ModisConstantsTest.assertEquals((String)"Dimension", (String)"Dimension");
        ModisConstantsTest.assertEquals((String)"DimensionMap", (String)"DimensionMap");
        ModisConstantsTest.assertEquals((String)"GeoField", (String)"GeoField");
        ModisConstantsTest.assertEquals((String)"DataField", (String)"DataField");
        ModisConstantsTest.assertEquals((String)"DimensionName", (String)"DimensionName");
        ModisConstantsTest.assertEquals((String)"Size", (String)"Size");
        ModisConstantsTest.assertEquals((String)"OBJECT", (String)"OBJECT");
        ModisConstantsTest.assertEquals((String)"END_OBJECT", (String)"END_OBJECT");
        ModisConstantsTest.assertEquals((String)"GeoDimension", (String)"GeoDimension");
        ModisConstantsTest.assertEquals((String)"DataDimension", (String)"DataDimension");
        ModisConstantsTest.assertEquals((String)"Offset", (String)"Offset");
        ModisConstantsTest.assertEquals((String)"Increment", (String)"Increment");
        ModisConstantsTest.assertEquals((String)"GeoFieldName", (String)"GeoFieldName");
        ModisConstantsTest.assertEquals((String)"DataType", (String)"DataType");
        ModisConstantsTest.assertEquals((String)"DimList", (String)"DimList");
        ModisConstantsTest.assertEquals((String)"DataFieldName", (String)"DataFieldName");
        ModisConstantsTest.assertEquals((String)"band_names", (String)"band_names");
        ModisConstantsTest.assertEquals((String)"valid_range", (String)"valid_range");
        ModisConstantsTest.assertEquals((String)"_FillValue", (String)"_FillValue");
        ModisConstantsTest.assertEquals((String)"GLOBAL_METADATA", (String)"GLOBAL_METADATA");
        ModisConstantsTest.assertEquals((String)"LOCALGRANULEID", (String)"LOCALGRANULEID");
        ModisConstantsTest.assertEquals((String)"SHORTNAME", (String)"SHORTNAME");
        ModisConstantsTest.assertEquals((String)"HDFEOSVersion", (String)"HDFEOSVersion");
        ModisConstantsTest.assertEquals((String)"RANGEBEGINNINGDATE", (String)"RANGEBEGINNINGDATE");
        ModisConstantsTest.assertEquals((String)"RANGEBEGINNINGTIME", (String)"RANGEBEGINNINGTIME");
        ModisConstantsTest.assertEquals((String)"RANGEENDINGDATE", (String)"RANGEENDINGDATE");
        ModisConstantsTest.assertEquals((String)"RANGEENDINGTIME", (String)"RANGEENDINGTIME");
    }

    public void testWavelengthsAndBandwidths() {
        ModisConstantsTest.assertEquals((int)expBandwidth.length, (int)ModisConstants.BAND_WIDTHS.length);
        ModisConstantsTest.assertEquals((int)expWavelength.length, (int)ModisConstants.BAND_CENTER_WAVELENGTHS.length);
        ModisConstantsTest.assertEquals((int)ModisConstants.BAND_WIDTHS.length, (int)ModisConstants.BAND_CENTER_WAVELENGTHS.length);
        for (int n = 0; n < ModisConstants.BAND_CENTER_WAVELENGTHS.length; ++n) {
            ModisConstantsTest.assertEquals((double)expBandwidth[n], (double)ModisConstants.BAND_WIDTHS[n], (double)1.0E-6);
            ModisConstantsTest.assertEquals((double)expWavelength[n], (double)ModisConstants.BAND_CENTER_WAVELENGTHS[n], (double)1.0E-6);
        }
    }

    public void testImappConstants() {
        ModisConstantsTest.assertEquals((String)"DAYNIGHTFLAG", (String)"DAYNIGHTFLAG");
        ModisConstantsTest.assertEquals((String)"Day", (String)"Day");
        ModisConstantsTest.assertEquals((String)"long_name", (String)"long_name");
    }

    public void testScalingConstants() {
        ModisConstantsTest.assertEquals((String)"exp", (String)"exp");
        ModisConstantsTest.assertEquals((String)"lin", (String)"lin");
        ModisConstantsTest.assertEquals((String)"lin_inv", (String)"lin_inv");
        ModisConstantsTest.assertEquals((String)"sli", (String)"sli");
        ModisConstantsTest.assertEquals((String)"p10", (String)"p10");
    }
}

