/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import junit.framework.TestCase;
import org.esa.beam.dataio.envisat.MerisProductFile;

public class MerisProductFileTest
extends TestCase {
    public void testDddbProductTypeReplacement() {
        int v5 = 5;
        this.testDddbProductTypeReplacement("MER_RR__1P_IODD5", "MER_RR__1P", 5);
        this.testDddbProductTypeReplacement("MER_FR__1P_IODD5", "MER_FR__1P", 5);
        this.testDddbProductTypeReplacement("MER_RR__2P_IODD6", "MER_RR__2P", 5);
        this.testDddbProductTypeReplacement("MER_RR__1C_IODD5", "MER_RR__1C", 5);
        this.testDddbProductTypeReplacement("MER_FR__2P_IODD6", "MER_FR__2P", 5);
        this.testDddbProductTypeReplacement("MER_RR__2C_IODD6", "MER_RR__2C", 5);
        this.testDddbProductTypeReplacement(null, "MERIS", 5);
        int v6 = 6;
        this.testDddbProductTypeReplacement(null, "MER_RR__1P", 6);
        this.testDddbProductTypeReplacement(null, "MER_FR__1P", 6);
        this.testDddbProductTypeReplacement("MER_RR__2P_IODD6", "MER_RR__2P", 6);
        this.testDddbProductTypeReplacement("MER_FR__2P_IODD6", "MER_FR__2P", 6);
        this.testDddbProductTypeReplacement("MER_RR__2C_IODD6", "MER_RR__2C", 6);
        this.testDddbProductTypeReplacement(null, "MERIS", 6);
        int v7 = 7;
        this.testDddbProductTypeReplacement(null, "MER_RR__1P", 7);
        this.testDddbProductTypeReplacement(null, "MER_FR__1P", 7);
        this.testDddbProductTypeReplacement("MER_RR__2P_IODD7", "MER_RR__2P", 7);
        this.testDddbProductTypeReplacement("MER_FR__2P_IODD7", "MER_FR__2P", 7);
        this.testDddbProductTypeReplacement(null, "MER_RR__1C", 7);
        this.testDddbProductTypeReplacement("MER_RR__2C_IODD7", "MER_RR__2C", 7);
        this.testDddbProductTypeReplacement("MER_FR__1P", "MER_FRS_1P", 7);
        this.testDddbProductTypeReplacement("MER_FR__1C", "MER_FRS_1C", 7);
        this.testDddbProductTypeReplacement("MER_FR__2P_IODD7", "MER_FRS_2P", 7);
        this.testDddbProductTypeReplacement("MER_FR__2C_IODD7", "MER_FRS_2C", 7);
        this.testDddbProductTypeReplacement(null, "MERIS", 7);
        int v8 = 8;
        this.testDddbProductTypeReplacement(null, "MER_RR__1P", 8);
        this.testDddbProductTypeReplacement(null, "MER_FR__1P", 8);
        this.testDddbProductTypeReplacement(null, "MER_RR__2P", 8);
        this.testDddbProductTypeReplacement(null, "MER_FR__2P", 8);
        this.testDddbProductTypeReplacement(null, "MER_RR__1C", 8);
        this.testDddbProductTypeReplacement(null, "MER_RR__2C", 8);
        this.testDddbProductTypeReplacement("MER_FR__1P", "MER_FRS_1P", 8);
        this.testDddbProductTypeReplacement("MER_FR__1C", "MER_FRS_1C", 8);
        this.testDddbProductTypeReplacement("MER_FR__2P", "MER_FRS_2P", 8);
        this.testDddbProductTypeReplacement("MER_FR__2C", "MER_FRS_2C", 8);
        this.testDddbProductTypeReplacement(null, "MERIS", 8);
        this.testDddbProductTypeReplacement(null, "MER_RR__1", -548);
    }

    private void testDddbProductTypeReplacement(String replacement, String productType, int ioddVersion5) {
        String s = MerisProductFile.getDddbProductTypeReplacement((String)productType, (int)ioddVersion5);
        MerisProductFileTest.assertEquals((String)replacement, (String)s);
    }
}

