/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.Header;
import org.esa.beam.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.beam.dataio.envisat.HeaderParseException;
import org.esa.beam.dataio.envisat.HeaderParser;
import org.esa.beam.util.Debug;

public class HeaderParserTest
extends TestCase {
    private boolean _oldDebugState;

    public HeaderParserTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(HeaderParserTest.class);
    }

    protected void setUp() {
        this._oldDebugState = Debug.setEnabled((boolean)false);
    }

    protected void tearDown() {
        Debug.setEnabled((boolean)this._oldDebugState);
    }

    public void testThatSingleEntriesAreParsedCorrectly() {
        Field param;
        Header header;
        String source;
        try {
            source = "TOT_SIZE=+00000000000186478394<bytes>\n";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertNotNull((Object)header.getParam("TOT_SIZE"));
            HeaderParserTest.assertNotNull((Object)header.getParam("tot_size"));
            HeaderParserTest.assertSame((Object)header.getParam("TOT_SIZE"), (Object)header.getParam("tot_size"));
            HeaderParserTest.assertEquals((int)1, (int)header.getNumParams());
            param = header.getParam("TOT_SIZE");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertNotNull((Object)param.getInfo());
            HeaderParserTest.assertEquals((String)"TOT_SIZE", (String)param.getInfo().getName());
            HeaderParserTest.assertEquals((int)22, (int)param.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)1, (int)param.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals((String)"bytes", (String)param.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)1, (int)param.getNumElems());
            HeaderParserTest.assertEquals((int)186478394, (int)param.getElemInt(0));
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
        try {
            source = "Z_VELOCITY=+7377.421000<m/s>\n";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)1, (int)header.getNumParams());
            param = header.getParam("Z_VELOCITY");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertNotNull((Object)param.getInfo());
            HeaderParserTest.assertEquals((String)"Z_VELOCITY", (String)param.getInfo().getName());
            HeaderParserTest.assertEquals((int)31, (int)param.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)1, (int)param.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals((String)"m/s", (String)param.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)1, (int)param.getNumElems());
            HeaderParserTest.assertEquals((double)7377.421, (double)param.getElemDouble(0), (double)1.0E-6);
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
        try {
            source = "COLUMN_SPACING=+2.60000000e+02<m>\n";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)1, (int)header.getNumParams());
            param = header.getParam("COLUMN_SPACING");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertNotNull((Object)param.getInfo());
            HeaderParserTest.assertEquals((String)"COLUMN_SPACING", (String)param.getInfo().getName());
            HeaderParserTest.assertEquals((int)31, (int)param.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)1, (int)param.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals((String)"m", (String)param.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)1, (int)param.getNumElems());
            HeaderParserTest.assertEquals((double)260.0, (double)param.getElemDouble(0), (double)1.0E-6);
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
        try {
            source = "DS_NAME=\"Cloud measurement parameters\"\n";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)1, (int)header.getNumParams());
            param = header.getParam("DS_NAME");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertNotNull((Object)param.getInfo());
            HeaderParserTest.assertEquals((String)"DS_NAME", (String)param.getInfo().getName());
            HeaderParserTest.assertEquals((int)41, (int)param.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)28, (int)param.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals(null, (String)param.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)28, (int)param.getNumElems());
            HeaderParserTest.assertEquals((String)"Cloud measurement parameters", (String)param.getAsString());
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
        try {
            source = "BAND_WAVELEN=+0000412500+0000442500+0000490000+0000510000+0000560000+0000620000+0000665000+0000681250+0000705000+0000753750+0000760625+0000775000+0000865000+0000885000+0000900000<10-3nm>";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)1, (int)header.getNumParams());
            param = header.getParam("BAND_WAVELEN");
            HeaderParserTest.assertEquals((int)12, (int)param.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)15, (int)param.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals((String)"10-3nm", (String)param.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)15, (int)param.getNumElems());
            HeaderParserTest.assertEquals((int)412500, (int)param.getElemInt(0));
            HeaderParserTest.assertEquals((int)442500, (int)param.getElemInt(1));
            HeaderParserTest.assertEquals((int)490000, (int)param.getElemInt(2));
            HeaderParserTest.assertEquals((int)510000, (int)param.getElemInt(3));
            HeaderParserTest.assertEquals((int)560000, (int)param.getElemInt(4));
            HeaderParserTest.assertEquals((int)620000, (int)param.getElemInt(5));
            HeaderParserTest.assertEquals((int)665000, (int)param.getElemInt(6));
            HeaderParserTest.assertEquals((int)681250, (int)param.getElemInt(7));
            HeaderParserTest.assertEquals((int)705000, (int)param.getElemInt(8));
            HeaderParserTest.assertEquals((int)753750, (int)param.getElemInt(9));
            HeaderParserTest.assertEquals((int)760625, (int)param.getElemInt(10));
            HeaderParserTest.assertEquals((int)775000, (int)param.getElemInt(11));
            HeaderParserTest.assertEquals((int)865000, (int)param.getElemInt(12));
            HeaderParserTest.assertEquals((int)885000, (int)param.getElemInt(13));
            HeaderParserTest.assertEquals((int)900000, (int)param.getElemInt(14));
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
        try {
            source = "DS_TYPE=A\nNUM_DSR=+0000036       ";
            header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)2, (int)header.getNumParams());
            Field param1 = header.getParam("DS_TYPE");
            HeaderParserTest.assertNotNull((Object)param1);
            HeaderParserTest.assertNotNull((Object)param1.getInfo());
            HeaderParserTest.assertEquals((String)"DS_TYPE", (String)param1.getInfo().getName());
            HeaderParserTest.assertEquals((int)41, (int)param1.getInfo().getDataType());
            HeaderParserTest.assertEquals(null, (String)param1.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)1, (int)param1.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals((String)"A", (String)param1.getAsString());
            Field param2 = header.getParam("NUM_DSR");
            HeaderParserTest.assertNotNull((Object)header.getParamAt(1));
            HeaderParserTest.assertNotNull((Object)param2.getInfo());
            HeaderParserTest.assertEquals((String)"NUM_DSR", (String)param2.getInfo().getName());
            HeaderParserTest.assertEquals((int)12, (int)param2.getInfo().getDataType());
            HeaderParserTest.assertEquals((int)1, (int)param2.getInfo().getNumDataElems());
            HeaderParserTest.assertEquals(null, (String)param2.getInfo().getPhysicalUnit());
            HeaderParserTest.assertEquals((int)1, (int)param2.getNumElems());
            HeaderParserTest.assertEquals((int)36, (int)param2.getElemInt(0));
            Debug.trace((String)("header: " + header));
        }
        catch (HeaderParseException e) {
            Debug.trace((Throwable)e);
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
    }

    public void testThatInvalidEntriesAreRejected() {
        String source;
        try {
            source = "=\"Holla Senor\"";
            HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.fail((String)"expected HeaderParseException since source is invalid");
        }
        catch (HeaderParseException e) {
            // empty catch block
        }
        try {
            source = "BIBO WAS HERE";
            HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.fail((String)"expected HeaderParseException since source is invalid");
        }
        catch (HeaderParseException e) {
            // empty catch block
        }
        try {
            source = new String(new byte[]{8, 27, 94, 10, 9, 4, 23, 56, 63, 3, 0, 0, 8, 7, 32, 32, 67});
            HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.fail((String)"expected HeaderParseException since source is invalid");
        }
        catch (HeaderParseException headerParseException) {
            // empty catch block
        }
    }

    public void testThatInvalidNumbersAreHandledAsStringValues() throws HeaderParseException, HeaderEntryNotFoundException {
        Header header = HeaderParser.getInstance().parseHeader("TEST", "X=+000+".getBytes());
        HeaderParserTest.assertEquals((int)41, (int)header.getParamDataType("X"));
        header = HeaderParser.getInstance().parseHeader("TEST", "X=+000+0a".getBytes());
        HeaderParserTest.assertEquals((int)41, (int)header.getParamDataType("X"));
        header = HeaderParser.getInstance().parseHeader("TEST", "X=+ 001".getBytes());
    }

    public void testThatNumericDataTypesAreHandledCorrectly() {
        try {
            String source = "AN_UINT32=+4294967295<bytes>\nAN_INT32=-2147483648<bytes>\nAN_UINT16=+65535<bytes>\nAN_INT16=-32768<bytes>\nAN_UINT8=+255<bytes>\nAN_INT8=-128<bytes>\nTRUE=1\nFALSE=0\n";
            Header header = HeaderParser.getInstance().parseHeader("TEST", source.getBytes());
            HeaderParserTest.assertNotNull((Object)header);
            HeaderParserTest.assertEquals((int)8, (int)header.getNumParams());
            Field param = header.getParam("AN_UINT32");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)22, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)0xFFFFFFFFL, (long)param.getElemLong(0));
            param = header.getParam("AN_INT32");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)12, (int)param.getDataType());
            HeaderParserTest.assertEquals((int)Integer.MIN_VALUE, (int)param.getElemInt(0));
            HeaderParserTest.assertEquals((long)Integer.MIN_VALUE, (long)param.getElemLong(0));
            param = header.getParam("AN_UINT16");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)12, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)65535L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)65535, (int)param.getElemInt(0));
            param = header.getParam("AN_INT16");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)12, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)-32768L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)Short.MIN_VALUE, (int)param.getElemInt(0));
            param = header.getParam("AN_UINT8");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)12, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)255L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)255, (int)param.getElemInt(0));
            param = header.getParam("AN_INT8");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)12, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)-128L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)-128, (int)param.getElemInt(0));
            param = header.getParam("TRUE");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)10, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)1L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)1, (int)param.getElemInt(0));
            param = header.getParam("FALSE");
            HeaderParserTest.assertNotNull((Object)param);
            HeaderParserTest.assertEquals((int)10, (int)param.getDataType());
            HeaderParserTest.assertEquals((long)0L, (long)param.getElemLong(0));
            HeaderParserTest.assertEquals((int)0, (int)param.getElemInt(0));
        }
        catch (HeaderParseException e) {
            HeaderParserTest.fail((String)("unexpected HeaderParseException: " + e.getMessage()));
        }
    }

    public void testARealLifeMPHExample() throws HeaderParseException {
        StringBuffer sb = new StringBuffer();
        sb.append("PRODUCT=\"MER_FR__2PTACR20000620_104323_00000099X000_00000_00000_0000.N1\"\n");
        sb.append("PROC_STAGE=T\n");
        sb.append("REF_DOC=\"PO-RS-MDA-GS-2009_3/B  \"\n");
        sb.append("\n");
        sb.append("ACQUISITION_STATION=\"ENVISAT SampleData#3\"\n");
        sb.append("PROC_CENTER=\"F-ACRI\"\n");
        sb.append("PROC_TIME=\"22-FEB-2000 19:41:46.000000\"\n");
        sb.append("SOFTWARE_VER=\"MEGS/4.3      \"\n");
        sb.append("\n");
        sb.append("SENSING_START=\"20-JUN-2000 10:43:23.851360\"\n");
        sb.append("SENSING_STOP=\"20-JUN-2000 10:45:02.411360\"\n");
        sb.append("\n");
        sb.append("PHASE=X\n");
        sb.append("CYCLE=+000\n");
        sb.append("REL_ORBIT=+00000\n");
        sb.append("ABS_ORBIT=+00000\n");
        sb.append("STATE_VECTOR_TIME=\"20-JUN-2000 10:06:52.269120\"\n");
        sb.append("DELTA_UT1=+.000000<s>\n");
        sb.append("X_POSITION=-7162215.231<m>\n");
        sb.append("Y_POSITION=+0208912.061<m>\n");
        sb.append("Z_POSITION=-0000004.200<m>\n");
        sb.append("X_VELOCITY=+0056.067000<m/s>\n");
        sb.append("Y_VELOCITY=+1629.960000<m/s>\n");
        sb.append("Z_VELOCITY=+7377.421000<m/s>\n");
        sb.append("VECTOR_SOURCE=\"00\"\n");
        sb.append("\n");
        sb.append("UTC_SBT_TIME=\"20-JUN-2000 06:29:50.343648\"\n");
        sb.append("SAT_BINARY_TIME=+0000000000\n");
        sb.append("CLOCK_STEP=+3906250000<ps>\n");
        sb.append("\n");
        sb.append("LEAP_UTC=\"                           \"\n");
        sb.append("LEAP_SIGN=+000\n");
        sb.append("LEAP_ERR=0\n");
        sb.append("\n");
        sb.append("PRODUCT_ERR=0\n");
        sb.append("TOT_SIZE=+00000000000186478394<bytes>\n");
        sb.append("SPH_SIZE=+0000011622<bytes>\n");
        sb.append("NUM_DSD=+0000000036\n");
        sb.append("DSD_SIZE=+0000000280<bytes>\n");
        sb.append("NUM_DATA_SETS=+0000000023\n");
        sb.append("\n");
        HeaderParser.getInstance().parseHeader("MPH", sb.toString().getBytes());
    }

    public void testARealLifeSPHExample() throws HeaderParseException {
        StringBuffer sb = new StringBuffer();
        sb.append("SPH_DESCRIPTOR=\"Level 2 Full Resolution     \"\n");
        sb.append("STRIPLINE_CONTINUITY_INDICATOR=+000\n");
        sb.append("SLICE_POSITION=+001\n");
        sb.append("NUM_SLICES=+001\n");
        sb.append("FIRST_LINE_TIME=\"20-JUN-2000 10:43:23.827346\"\n");
        sb.append("LAST_LINE_TIME=\"20-JUN-2000 10:45:02.387346\"\n");
        sb.append("FIRST_FIRST_LAT=+0048477538<10-6degN>\n");
        sb.append("FIRST_FIRST_LONG=-0000848029<10-6degE>\n");
        sb.append("FIRST_MID_LAT=+0049120852<10-6degN>\n");
        sb.append("FIRST_MID_LONG=-0004690841<10-6degE>\n");
        sb.append("FIRST_LAST_LAT=+0049633188<10-6degN>\n");
        sb.append("FIRST_LAST_LONG=-0008623846<10-6degE>\n");
        sb.append("LAST_FIRST_LAT=+0042727139<10-6degN>\n");
        sb.append("AST_FIRST_LONG=-0003066400<10-6degE>\n");
        sb.append("LAST_MID_LAT=+0043337479<10-6degN>\n");
        sb.append("LAST_MID_LONG=-0006541594<10-6degE>\n");
        sb.append("LAST_LAST_LAT=+0043840261<10-6degN>\n");
        sb.append("LAST_LAST_LONG=-0010080759<10-6degE>\n");
        sb.append("\n");
        sb.append("TRANS_ERR_FLAG=0\n");
        sb.append("FORMAT_ERR_FLAG=0\n");
        sb.append("DATABASE_FLAG=0\n");
        sb.append("COARSE_ERR_FLAG=0\n");
        sb.append("ECMWF_TYPE=1\n");
        sb.append("NUM_TRANS_ERR=+0000000000\n");
        sb.append("NUM_FORMAT_ERR=+0000000000\n");
        sb.append("TRANS_ERR_THRESH=+0.00000000e+00<%>\n");
        sb.append("FORMAT_ERR_THRESH=+0.00000000e+00<%>\n");
        sb.append("\n");
        sb.append("NUM_BANDS=+015\n");
        sb.append("BAND_WAVELEN=+0000412500+0000442500+0000490000+0000510000+0000560000+0000620000+0000665000+0000681250+0000705000+0000753750+0000760625+0000775000+0000865000+0000885000+0000900000<10-3nm>\n");
        sb.append("BANDWIDTH=+10000+10000+10000+10000+10000+10000+10000+07500+10000+07500+03750+15000+20000+10000+10000<10-3nm>\n");
        sb.append("INST_FOV=+0000019151<10-6deg>\n");
        sb.append("PROC_MODE=0\n");
        sb.append("OFFSET_COMP=1\n");
        sb.append("LINE_TIME_INTERVAL=+0000044000<10-6s>\n");
        sb.append("LINE_LENGTH=+02241<samples>\n");
        sb.append("LINES_PER_TIE_PT=+064\n");
        sb.append("SAMPLES_PER_TIE_PT=+064\n");
        sb.append("COLUMN_SPACING=+2.60000000e+02<m>\n");
        sb.append("\n");
        HeaderParser.getInstance().parseHeader("SPH", sb.toString().getBytes());
    }

    public void testARealLifeDSDExample() throws HeaderParseException {
        StringBuffer sb = new StringBuffer();
        sb.append("DS_NAME=\"Quality ADS                 \"\n");
        sb.append("DS_TYPE=A\n");
        sb.append("FILENAME=\"                                                              \"\n");
        sb.append("DS_OFFSET=+00000000000000012869<bytes>\n");
        sb.append("DS_SIZE=+00000000000000000160<bytes>\n");
        sb.append("NUM_DSR=+0000000005\n");
        sb.append("DSR_SIZE=+0000000032<bytes>\n");
        sb.append("\n");
        HeaderParser.getInstance().parseHeader("DSD(1)", sb.toString().getBytes());
    }

    public final void testGetAsDate() throws HeaderParseException, HeaderEntryNotFoundException {
        StringBuffer sb = new StringBuffer();
        sb.append("SENSING_START=\"20-JAN-2000 10:43:23.851360\"\n");
        Header header = HeaderParser.getInstance().parseHeader("MPH", sb.toString().getBytes());
        Date paramDate = header.getParamDate("SENSING_START");
        long mjd2kOffset = 946684800000L;
        HeaderParserTest.assertEquals((long)948365003851L, (long)paramDate.getTime());
    }
}

