/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.FieldInfo;

public class FieldTest
extends TestCase {
    Field[] _fields;

    public FieldTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(FieldTest.class);
    }

    protected void setUp() {
        FieldInfo[] fieldInfos = new FieldInfo[]{new FieldInfo("_fiByte", 10, 4, null, null), new FieldInfo("_fiUByte", 20, 4, null, null), new FieldInfo("_fiShort", 11, 4, null, null), new FieldInfo("_fiUShort", 21, 4, null, null), new FieldInfo("_fiInt", 12, 4, null, null), new FieldInfo("_fiUInt", 22, 4, null, null), new FieldInfo("_fiFloat", 30, 4, null, null), new FieldInfo("_fiDouble", 31, 4, null, null), new FieldInfo("_fiUTC", 51, 4, null, null), new FieldInfo("_fiAscii", 41, 4, null, null)};
        Object[] fieldValues = new Object[]{new byte[]{1, 2, -3, -4}, new byte[]{1, 2, -126, -125}, new short[]{1, 2, -3, -4}, new short[]{1, 2, -32766, -32765}, new int[]{1, 2, -3, -4}, new int[]{1, 2, -2147483646, -2147483645}, new float[]{1.0f, 2.0f, -3.0f, -4.0f}, new double[]{1.0, 2.0, -3.0, -4.0}, new int[]{1, 2, 3}, "ABCD".getBytes()};
        this._fields = new Field[fieldInfos.length];
        for (int i = 0; i < fieldInfos.length; ++i) {
            this._fields[i] = fieldInfos[i].createField();
            this._fields[i].setValue(fieldValues[i]);
        }
    }

    protected void tearDown() {
        this._fields = null;
    }

    public void testCreate() {
        try {
            new Field(null);
            FieldTest.fail((String)"IllegalArgumentException expected: field info must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetData() {
        FieldTest.assertTrue((boolean)(this._fields[0].getElems() instanceof byte[]));
        FieldTest.assertTrue((boolean)(this._fields[1].getElems() instanceof byte[]));
        FieldTest.assertTrue((boolean)(this._fields[2].getElems() instanceof short[]));
        FieldTest.assertTrue((boolean)(this._fields[3].getElems() instanceof short[]));
        FieldTest.assertTrue((boolean)(this._fields[4].getElems() instanceof int[]));
        FieldTest.assertTrue((boolean)(this._fields[5].getElems() instanceof int[]));
        FieldTest.assertTrue((boolean)(this._fields[6].getElems() instanceof float[]));
        FieldTest.assertTrue((boolean)(this._fields[7].getElems() instanceof double[]));
        FieldTest.assertTrue((boolean)(this._fields[8].getElems() instanceof int[]));
        FieldTest.assertTrue((boolean)(this._fields[9].getElems() instanceof byte[]));
    }

    public void testGetDataType() {
        FieldTest.assertEquals((int)10, (int)this._fields[0].getDataType());
        FieldTest.assertEquals((int)20, (int)this._fields[1].getDataType());
        FieldTest.assertEquals((int)11, (int)this._fields[2].getDataType());
        FieldTest.assertEquals((int)21, (int)this._fields[3].getDataType());
        FieldTest.assertEquals((int)12, (int)this._fields[4].getDataType());
        FieldTest.assertEquals((int)22, (int)this._fields[5].getDataType());
        FieldTest.assertEquals((int)30, (int)this._fields[6].getDataType());
        FieldTest.assertEquals((int)31, (int)this._fields[7].getDataType());
        FieldTest.assertEquals((int)51, (int)this._fields[8].getDataType());
        FieldTest.assertEquals((int)41, (int)this._fields[9].getDataType());
    }
}

