/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Scanner;
import org.esa.beam.dataio.envisat.EnvisatProductReader;
import org.esa.beam.dataio.envisat.EnvisatProductReaderPlugIn;
import org.esa.beam.dataio.envisat.ProductFile;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EnvisatProductReaderTest {
    private EnvisatProductReaderPlugIn readerPlugIn;

    @Before
    public void setUp() {
        this.readerPlugIn = new EnvisatProductReaderPlugIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAatsrGeoLocation_UpperRightCorner() throws IOException, URISyntaxException {
        try (EnvisatProductReader reader = (EnvisatProductReader)this.readerPlugIn.createReaderInstance();){
            Product product = reader.readProductNodes((Object)new File(this.getClass().getResource("ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.N1").toURI()), null);
            Assert.assertEquals((long)512L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)320L, (long)product.getSceneRasterHeight());
            TiePointGrid latGrid = product.getTiePointGrid("latitude");
            TiePointGrid lonGrid = product.getTiePointGrid("longitude");
            Assert.assertNotNull((Object)latGrid);
            Assert.assertNotNull((Object)lonGrid);
            ProductFile productFile = reader.getProductFile();
            Assert.assertTrue((boolean)productFile.storesPixelsInChronologicalOrder());
            int colCount = 512;
            int rowCount = 320;
            float[] lats = new float[163840];
            float[] lons = new float[163840];
            this.readFloats("image_latgrid_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lats);
            this.readFloats("image_longrid_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lons);
            GeoPos geoPos = new GeoPos();
            product.getGeoCoding().getGeoPos(new PixelPos(1.0f, 0.0f), geoPos);
            Assert.assertEquals((float)44.550716f, (float)geoPos.getLat(), (float)1.0E-5f);
            Assert.assertEquals((float)32.87879f, (float)geoPos.getLon(), (float)1.0E-5f);
            product.getGeoCoding().getGeoPos(new PixelPos(6.0f, 0.0f), geoPos);
            Assert.assertEquals((float)44.541008f, (float)geoPos.getLat(), (float)1.0E-5f);
            Assert.assertEquals((float)32.94025f, (float)geoPos.getLon(), (float)1.0E-5f);
            for (int i = 0; i < 320; ++i) {
                int j = 0;
                int k = 511;
                while (j < 512) {
                    product.getGeoCoding().getGeoPos(new PixelPos((float)j + 1.0f, (float)i + 0.0f), geoPos);
                    Assert.assertEquals((float)lats[i * 512 + k], (float)geoPos.getLat(), (float)1.2E-5f);
                    Assert.assertEquals((float)lons[i * 512 + k], (float)geoPos.getLon(), (float)1.2E-5f);
                    ++j;
                    --k;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testAatsrGeoLocation_Center() throws IOException, URISyntaxException {
        try (EnvisatProductReader reader = (EnvisatProductReader)this.readerPlugIn.createReaderInstance();){
            Product product = reader.readProductNodes((Object)new File(this.getClass().getResource("ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.N1").toURI()), null);
            Assert.assertEquals((long)512L, (long)product.getSceneRasterWidth());
            Assert.assertEquals((long)320L, (long)product.getSceneRasterHeight());
            TiePointGrid latGrid = product.getTiePointGrid("latitude");
            TiePointGrid lonGrid = product.getTiePointGrid("longitude");
            Assert.assertNotNull((Object)latGrid);
            Assert.assertNotNull((Object)lonGrid);
            ProductFile productFile = reader.getProductFile();
            Assert.assertTrue((boolean)productFile.storesPixelsInChronologicalOrder());
            int colCount = 512;
            int rowCount = 320;
            float[] lats = new float[163840];
            float[] lons = new float[163840];
            this.readFloats("image_latgrid_centre_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lats);
            this.readFloats("image_longrid_centre_ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.txt", lons);
            GeoPos geoPos = new GeoPos();
            for (int i = 0; i < 320; ++i) {
                int j = 0;
                int k = 511;
                while (j < 512) {
                    product.getGeoCoding().getGeoPos(new PixelPos((float)j + 0.5f, (float)i + 0.5f), geoPos);
                    Assert.assertEquals((float)lats[i * 512 + k], (float)geoPos.getLat(), (float)1.2E-5f);
                    Assert.assertEquals((float)lons[i * 512 + k], (float)geoPos.getLon(), (float)1.2E-5f);
                    ++j;
                    --k;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFloats(String resourceName, float[] floats) {
        Scanner scanner = new Scanner(this.getClass().getResourceAsStream(resourceName), "US-ASCII");
        scanner.useLocale(Locale.ENGLISH);
        try {
            for (int i = 0; i < floats.length; ++i) {
                floats[i] = scanner.nextFloat();
            }
        }
        finally {
            scanner.close();
        }
    }
}

