/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.envisat.EnvisatAuxReader;
import org.esa.beam.dataio.envisat.EnvisatOrbitReader;
import org.esa.beam.framework.datamodel.ProductData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnvisatOrbitReaderTest {
    private static final String doris_por_orbit = "org/esa/beam/resources/testdata/DOR_POR_AXVF-P20080404_014700_20080401_215527_20080403_002327";
    private static final String doris_vor_orbit = "org/esa/beam/resources/testdata/DOR_VOR_AXVF-P20080331_075200_20080301_215527_20080303_002327";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPOROrbitFiles() throws IOException {
        File orbFile = EnvisatAuxReader.getFile((String)doris_por_orbit);
        if (!orbFile.exists()) {
            return;
        }
        EnvisatOrbitReader reader = new EnvisatOrbitReader();
        reader.readProduct((Object)doris_por_orbit);
        EnvisatOrbitReader.OrbitVector orb = EnvisatOrbitReaderTest.getOrbitData(reader);
        ProductData.UTC utc = new ProductData.UTC(orb.utcTime);
        Assert.assertEquals((Object)"01-APR-2008 21:55:27.000000", (Object)utc.format());
        Assert.assertEquals((double)-3300453.451, (double)orb.xPos, (double)1.0E-8);
        Assert.assertEquals((double)881817.654, (double)orb.yPos, (double)1.0E-8);
        Assert.assertEquals((double)-6304026.222, (double)orb.zPos, (double)1.0E-8);
        Assert.assertEquals((double)6673.625193, (double)orb.xVel, (double)1.0E-8);
        Assert.assertEquals((double)880.089573, (double)orb.yVel, (double)1.0E-8);
        Assert.assertEquals((double)-3372.728885, (double)orb.zVel, (double)1.0E-8);
    }

    @Test
    public void testVOROrbitFiles() throws IOException {
        File orbFile = EnvisatAuxReader.getFile((String)doris_vor_orbit);
        if (!orbFile.exists()) {
            return;
        }
        EnvisatOrbitReader reader = new EnvisatOrbitReader();
        reader.readProduct((Object)doris_vor_orbit);
        EnvisatOrbitReader.OrbitVector orb = EnvisatOrbitReaderTest.getOrbitData(reader);
        ProductData.UTC utc = new ProductData.UTC(orb.utcTime);
        Assert.assertEquals((Object)"01-MAR-2008 21:55:27.000000", (Object)utc.format());
        Assert.assertEquals((double)6494931.106, (double)orb.xPos, (double)1.0E-8);
        Assert.assertEquals((double)578715.148, (double)orb.yPos, (double)1.0E-8);
        Assert.assertEquals((double)-2977719.455, (double)orb.zPos, (double)1.0E-8);
        Assert.assertEquals((double)3188.730641, (double)orb.xVel, (double)1.0E-8);
        Assert.assertEquals((double)-1416.295158, (double)orb.yVel, (double)1.0E-8);
        Assert.assertEquals((double)6692.698996, (double)orb.zVel, (double)1.0E-8);
    }

    @Test
    public void testInterpolation() throws Exception {
        File orbFile = EnvisatAuxReader.getFile((String)doris_vor_orbit);
        if (!orbFile.exists()) {
            return;
        }
        EnvisatOrbitReader reader = new EnvisatOrbitReader();
        reader.readProduct((Object)doris_vor_orbit);
        reader.readOrbitData();
        double utc1 = reader.getOrbitVector((int)1).utcTime;
        double utc2 = reader.getOrbitVector((int)2).utcTime;
        double utc = 0.3 * utc1 + 0.7 * utc2;
        EnvisatOrbitReader.OrbitVector orb = reader.getOrbitVector(utc);
        Assert.assertEquals((double)6782111.692571748, (double)orb.xPos, (double)1.0E-8);
        Assert.assertEquals((double)429053.84925767, (double)orb.yPos, (double)1.0E-8);
        Assert.assertEquals((double)-2279551.9462241037, (double)orb.zPos, (double)1.0E-8);
        Assert.assertEquals((double)2436.6730959241404, (double)orb.xVel, (double)1.0E-8);
        Assert.assertEquals((double)-1513.6396683722035, (double)orb.yVel, (double)1.0E-8);
        Assert.assertEquals((double)6984.008122409866, (double)orb.zVel, (double)1.0E-8);
    }

    static EnvisatOrbitReader.OrbitVector getOrbitData(EnvisatOrbitReader reader) throws IOException {
        reader.readOrbitData();
        int numRecords = reader.getNumRecords();
        EnvisatOrbitReader.OrbitVector orb = reader.getOrbitVector(0);
        Assert.assertNotNull((Object)orb);
        EnvisatOrbitReader.OrbitVector orb2 = reader.getOrbitVector(numRecords - 1);
        Assert.assertNotNull((Object)orb2);
        return orb;
    }
}

