/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import junit.framework.TestCase;
import org.esa.beam.dataio.envisat.AsarProductFile;

public class AsarProductFileTest
extends TestCase {
    public void testDddbProductTypeReplacement() {
        AsarProductFile.IODD v3K = AsarProductFile.IODD.ASAR_3K;
        AsarProductFileTest.testDddbProductTypeReplacement("ASA_IMG_1P_IODD_3K", "ASA_IMG_1P", v3K);
        AsarProductFileTest.testDddbProductTypeReplacement("ASAR", "ASAR", v3K);
        AsarProductFile.IODD v4A = AsarProductFile.IODD.ASAR_4A;
        AsarProductFileTest.testDddbProductTypeReplacement("ASA_IMG_1P_IODD_4A", "ASA_IMG_1P", v4A);
        AsarProductFileTest.testDddbProductTypeReplacement("ASAR", "ASAR", v4A);
        AsarProductFile.IODD v4B = AsarProductFile.IODD.ASAR_4B;
        AsarProductFileTest.testDddbProductTypeReplacement("ASA_WSM_1P_IODD_4B", "ASA_WSM_1P", v4B);
        AsarProductFileTest.testDddbProductTypeReplacement("ASA_IMG_1P_IODD_4A", "ASA_IMG_1P", v4B);
        AsarProductFileTest.testDddbProductTypeReplacement("ASAR", "ASAR", v4B);
        AsarProductFile.IODD vUnknown = AsarProductFile.IODD.VERSION_UNKNOWN;
        AsarProductFileTest.testDddbProductTypeReplacement("ASA_IMG_1P", "ASA_IMG_1P", vUnknown);
        AsarProductFileTest.testDddbProductTypeReplacement("ASAR", "ASAR", vUnknown);
    }

    private static void testDddbProductTypeReplacement(String replacement, String productType, AsarProductFile.IODD ioddVersion) {
        String s = AsarProductFile.getDddbProductTypeReplacement((String)productType, (AsarProductFile.IODD)ioddVersion);
        AsarProductFileTest.assertEquals((String)replacement, (String)s);
    }
}

