/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.dataio.envisat.AatsrProductFile;
import org.esa.beam.dataio.envisat.DSD;
import org.junit.Assert;
import org.junit.Test;

public class AatsrProductFileTest {
    @Test
    public void testCalculateSceneRasterHeight_MDS_DSD_matches() {
        int numRecords_1 = 109;
        int numRecords_2 = 1865;
        int numLines_1 = 3456;
        int numLines_2 = 59648;
        DSD geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 109, 14);
        Assert.assertEquals((long)3456L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)3456));
        geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 1865, 14);
        Assert.assertEquals((long)59648L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)59648));
    }

    @Test
    public void testCalculateSceneRasterHeight_MDS_DSD_lessLines() {
        int numRecords_1 = 109;
        int numRecords_2 = 1865;
        int numLines_1 = 3456;
        int numLines_2 = 59648;
        DSD geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 109, 14);
        Assert.assertEquals((long)3456L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)3444));
        geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 1865, 14);
        Assert.assertEquals((long)59648L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)59624));
    }

    @Test
    public void testCalculateSceneRasterHeight_MDS_DSD_moreLines() {
        int numRecords_1 = 109;
        int numRecords_2 = 1865;
        int numLines_1 = 3456;
        int numLines_2 = 59648;
        DSD geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 109, 14);
        Assert.assertEquals((long)3461L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)3461));
        geolocationDSD = new DSD(0, "ignore", 'A', "", 12L, 13L, 1865, 14);
        Assert.assertEquals((long)59659L, (long)AatsrProductFile.calculateSceneRasterHeight((DSD)geolocationDSD, (int)59659));
    }
}

