/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.StxFactory;

public class StxPerformanceCheck {
    public static void main(String[] args) throws Exception {
        System.out.println("Stx computation performance test:");
        System.out.println("=================================");
        for (String filePath : args) {
            StxPerformanceCheck.performBandTest(filePath);
        }
    }

    private static void performBandTest(String filePath) throws IOException {
        Product product = ProductIO.readProduct((String)filePath);
        Band band0 = product.getBandAt(0);
        double[] times = StxPerformanceCheck.computeStx(band0);
        System.out.println(product.getProductType());
        System.out.println("band width : " + band0.getSceneRasterWidth());
        System.out.println("band height: " + band0.getSceneRasterHeight());
        System.out.println();
        for (int i = 0; i < times.length; ++i) {
            System.out.println("stx" + i + " : " + times[i]);
        }
        System.out.println();
    }

    private static double[] computeStx(Band band) {
        double[] times = new double[3];
        for (int i = 0; i < times.length; ++i) {
            times[i] = StxPerformanceCheck.computeStxOnce(band);
        }
        return times;
    }

    private static double computeStxOnce(Band band) {
        long t0 = System.nanoTime();
        new StxFactory().create((RasterDataNode)band, ProgressMonitor.NULL);
        long t1 = System.nanoTime();
        return (double)(t1 - t0) / 1000000.0;
    }
}

