/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.envisat.ProductFile;
import org.esa.beam.framework.datamodel.ProductData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProductFileTest {
    ProductFile productFile;

    @Before
    public void setUp() throws Exception {
        File file = new File(this.getClass().getResource("ATS_TOA_1PRMAP20050504_080932_000000482037_00020_16607_0001.N1").toURI());
        String productType = ProductFile.getProductType((File)file);
        Assert.assertEquals((Object)"ATS_TOA_1P", (Object)productType);
        this.productFile = ProductFile.open((File)file);
        Assert.assertNotNull((Object)this.productFile);
    }

    @After
    public void tearDown() throws Exception {
        this.productFile.close();
    }

    @Test
    public void testRecordTime() throws IOException {
        String[] validDatasetNames = this.productFile.getValidDatasetNames(77);
        Assert.assertEquals((long)18L, (long)validDatasetNames.length);
        ProductData.UTC utc1 = this.productFile.getRecordTime(validDatasetNames[0], "dsr_time", 0);
        Assert.assertEquals((Object)"04-MAY-2005 08:09:32.862224", (Object)utc1.format());
        ProductData.UTC utc2 = this.productFile.getRecordTime(validDatasetNames[0], "dsr_time", 1);
        Assert.assertEquals((Object)"04-MAY-2005 08:09:33.012223", (Object)utc2.format());
        ProductData.UTC utc3 = this.productFile.getRecordTime(validDatasetNames[0], "dsr_time", 2);
        Assert.assertEquals((Object)"04-MAY-2005 08:09:33.162223", (Object)utc3.format());
        Assert.assertEquals((double)1.7361E-6, (double)(utc2.getMJD() - utc1.getMJD()), (double)1.0E-10);
        Assert.assertEquals((double)1.7361E-6, (double)(utc3.getMJD() - utc2.getMJD()), (double)1.0E-10);
    }

    @Test
    public void testAllRecordTimes() throws IOException {
        String[] validDatasetNames = this.productFile.getValidDatasetNames(77);
        Assert.assertEquals((long)18L, (long)validDatasetNames.length);
        int numRecs = this.productFile.getSceneRasterHeight();
        Assert.assertEquals((long)320L, (long)numRecs);
        ProductData.UTC[] recordTimes = this.productFile.getAllRecordTimes();
        Assert.assertEquals((long)numRecs, (long)recordTimes.length);
        Assert.assertEquals((Object)"04-MAY-2005 08:09:32.862224", (Object)recordTimes[0].format());
        Assert.assertEquals((Object)"04-MAY-2005 08:09:33.012223", (Object)recordTimes[1].format());
        Assert.assertEquals((Object)"04-MAY-2005 08:09:33.162223", (Object)recordTimes[2].format());
        Assert.assertEquals((Object)"04-MAY-2005 08:10:20.412223", (Object)recordTimes[numRecs - 3].format());
        Assert.assertEquals((Object)"04-MAY-2005 08:10:20.562223", (Object)recordTimes[numRecs - 2].format());
        Assert.assertEquals((Object)"04-MAY-2005 08:10:20.712223", (Object)recordTimes[numRecs - 1].format());
        double minDiffTime = Double.POSITIVE_INFINITY;
        double maxDiffTime = Double.NEGATIVE_INFINITY;
        double meanDiffTime = 0.0;
        ProductData.UTC lastTime = null;
        for (ProductData.UTC time : recordTimes) {
            if (lastTime != null) {
                double dt = time.getMJD() - lastTime.getMJD();
                meanDiffTime += dt;
                minDiffTime = Math.min(minDiffTime, dt);
                maxDiffTime = Math.max(maxDiffTime, dt);
            }
            lastTime = time;
        }
        Assert.assertEquals((double)1.73611107E-6, (double)(meanDiffTime /= (double)(numRecs - 1)), (double)1.0E-12);
        Assert.assertEquals((double)1.73609942E-6, (double)minDiffTime, (double)1.0E-12);
        Assert.assertEquals((double)1.73612261E-6, (double)maxDiffTime, (double)1.0E-12);
    }

    @Test
    public void testScanLineTimeDiffs() throws IOException {
        String[] validDatasetNames = this.productFile.getValidDatasetNames(77);
        Assert.assertEquals((long)18L, (long)validDatasetNames.length);
        ProductData.UTC[] recordTimes = this.productFile.getAllRecordTimes();
        double minDiffTime = Double.POSITIVE_INFINITY;
        double maxDiffTime = Double.NEGATIVE_INFINITY;
        double meanDiffTime = 0.0;
        ProductData.UTC lastTime = null;
        for (ProductData.UTC time : recordTimes) {
            if (lastTime != null) {
                double dt = time.getMJD() - lastTime.getMJD();
                meanDiffTime += dt;
                minDiffTime = Math.min(minDiffTime, dt);
                maxDiffTime = Math.max(maxDiffTime, dt);
            }
            lastTime = time;
        }
        Assert.assertEquals((double)1.73611107E-6, (double)(meanDiffTime /= (double)(recordTimes.length - 1)), (double)1.0E-12);
        Assert.assertEquals((double)1.73609942E-6, (double)minDiffTime, (double)1.0E-12);
        Assert.assertEquals((double)1.73612261E-6, (double)maxDiffTime, (double)1.0E-12);
    }
}

