/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.dataio.envisat.DDDB;
import org.esa.beam.dataio.envisat.EnvisatConstants;
import org.esa.beam.util.io.CsvReader;

public class EnvisatConstantsTest
extends TestCase {
    public EnvisatConstantsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EnvisatConstantsTest.class);
    }

    public void testMERIS_FR_L1B_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/MER_FR__1P.dd", "MER_FR__1P");
    }

    public void testMERIS_RR_L1B_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/MER_RR__1P.dd", "MER_RR__1P");
    }

    public void testMERIS_FR_L2_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/MER_FR__2P.dd", "MER_FR__2P");
    }

    public void testMERIS_RR_L2_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/MER_RR__2P.dd", "MER_RR__2P");
    }

    public void testAATSR_FR_L1B_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/ATS_TOA_1P.dd", "ATS_TOA_1P");
    }

    public void testAATSR_FR_L2_TYPE() throws IOException {
        EnvisatConstantsTest.testProductTypeExistsInFirstLine("/products/ATS_NR__2P.dd", "ATS_NR__2P");
    }

    public void testMERIS_L1_MDS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_L1B_BAND_NAMES, "/bands/MER_RR__1P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_L1B_BAND_NAMES, "/bands/MER_FR__1P.dd");
    }

    public void testMERIS_L2_MDS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_L2_BAND_NAMES, "/bands/MER_RR__2P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_L2_BAND_NAMES, "/bands/MER_FR__2P.dd");
    }

    public void testMERIS_ADS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES, "/bands/MER_RR__1P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES, "/bands/MER_FR__1P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES, "/bands/MER_RR__2P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES, "/bands/MER_FR__2P.dd");
    }

    public void testAATSR_L1_MDS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.AATSR_L1B_BAND_NAMES, "/bands/ATS_TOA_1P.dd");
    }

    public void testAATSR_ADS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.AATSR_TIE_POINT_GRID_NAMES, "/bands/ATS_TOA_1P.dd");
        EnvisatConstantsTest.existsInFile(EnvisatConstants.AATSR_TIE_POINT_GRID_NAMES, "/bands/ATS_NR__2P.dd");
    }

    public void testAATSR_L2_MDS_NAMES() throws IOException {
        EnvisatConstantsTest.existsInFile(EnvisatConstants.AATSR_L2_BAND_NAMES, "/bands/ATS_NR__2P.dd");
    }

    private static LineNumberReader createLineReader(String resourcePath) throws IOException {
        return new LineNumberReader(new InputStreamReader(DDDB.getDatabaseResource((String)resourcePath).openStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void existsInFile(String[] expectedValues, String resourcePath) throws IOException {
        CsvReader csvReader = new CsvReader((Reader)EnvisatConstantsTest.createLineReader(resourcePath), new char[]{'|'}, true, "#");
        List recordSet = csvReader.readStringRecords();
        try {
            for (String expectedValue : expectedValues) {
                EnvisatConstantsTest.assertTrue((String)("expected '" + expectedValue + "' in " + resourcePath), (boolean)EnvisatConstantsTest.existsInRecordSet(expectedValue, recordSet, 0));
            }
        }
        finally {
            csvReader.close();
        }
    }

    private static boolean existsInRecordSet(String expectedValue, List<String[]> recordSet, int column) {
        for (String[] record : recordSet) {
            if (!expectedValue.equals(record[column])) continue;
            return true;
        }
        return false;
    }

    private static void testProductTypeExistsInFirstLine(String resourcePath, String productType) throws IOException {
        LineNumberReader reader = EnvisatConstantsTest.createLineReader(resourcePath);
        String line = reader.readLine();
        reader.close();
        EnvisatConstantsTest.assertNotNull((Object)line);
        EnvisatConstantsTest.assertTrue((boolean)line.contains(productType));
    }
}

