/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.envisat.AatsrProductFile;
import org.esa.beam.dataio.envisat.AsarProductFile;
import org.esa.beam.dataio.envisat.AsarXCAProductFile;
import org.esa.beam.dataio.envisat.BandInfo;
import org.esa.beam.dataio.envisat.BandLineReader;
import org.esa.beam.dataio.envisat.DDDB;
import org.esa.beam.dataio.envisat.DDDBException;
import org.esa.beam.dataio.envisat.DSD;
import org.esa.beam.dataio.envisat.DorisOrbitProductFile;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.FieldInfo;
import org.esa.beam.dataio.envisat.Header;
import org.esa.beam.dataio.envisat.HeaderParseException;
import org.esa.beam.dataio.envisat.HeaderParser;
import org.esa.beam.dataio.envisat.LineInterleavedRecordReader;
import org.esa.beam.dataio.envisat.MerisProductFile;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.dataio.envisat.RecordInfo;
import org.esa.beam.dataio.envisat.RecordReader;
import org.esa.beam.framework.dataio.IllegalFileFormatException;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;

public abstract class ProductFile {
    public static final String KEY_SENSING_START = "SENSING_START";
    public static final String KEY_SENSING_STOP = "SENSING_STOP";
    private final File file;
    private final ImageInputStream dataInputStream;
    private final Logger logger;
    private Header mph;
    private Header sph;
    private DSD[] dsdArray;
    private Record gads;
    private String productId;
    private String productType;
    private int productSize;
    private int sphSize;
    private int dsdSize;
    private int numDSDs;
    private int numDatasets;
    private Date sensingStart;
    private Date sensingStop;
    private final Map<String, RecordReader> recordReaderCache = new Hashtable<String, RecordReader>();
    private final Map parameters = new Hashtable();
    private BandLineReader[] bandLineReaders;
    private Map<Band, BandLineReader> bandLineReaderMap;
    private String _productDescription;
    private final boolean lineInterleaved;

    protected ProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        this(file, dataInputStream, false);
    }

    protected ProductFile(File file, ImageInputStream dataInputStream, boolean lineInterleaved) throws IOException {
        Debug.assertTrue((dataInputStream != null ? 1 : 0) != 0);
        this.file = file;
        this.dataInputStream = dataInputStream;
        this.lineInterleaved = lineInterleaved;
        this.logger = BeamLogManager.getSystemLogger();
        this.init();
    }

    public static ProductFile open(String filePath) throws IOException {
        return ProductFile.open(new File(filePath));
    }

    public static ProductFile open(File file) throws IOException {
        return ProductFile.open(file, new FileImageInputStream(file));
    }

    public static ProductFile open(ImageInputStream dataInputStream) throws IOException {
        return ProductFile.open(null, dataInputStream);
    }

    public File getFile() {
        return this.file;
    }

    public static boolean isEnvisatFile(File file) {
        return ProductFile.getProductType(file) != null;
    }

    public String getProductId() {
        return this.productId;
    }

    public static String getProductType(File file) {
        FileImageInputStream dataInputStream = null;
        String productType = null;
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            dataInputStream = new FileImageInputStream(file);
            productType = ProductFile.getProductType(dataInputStream);
        }
        catch (IOException e) {
            Debug.trace((Throwable)e);
        }
        try {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (IOException e) {
            Debug.trace((Throwable)e);
        }
        return productType;
    }

    public static String getProductType(ImageInputStream dataInputStream) {
        String productType = null;
        try {
            productType = ProductFile.readProductType(dataInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return productType;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getProductDescription() {
        return this._productDescription;
    }

    protected String getDddbProductType() {
        return this.getProductType();
    }

    public abstract ProductData.UTC getSceneRasterStartTime();

    public abstract ProductData.UTC getSceneRasterStopTime();

    public abstract int getSceneRasterWidth();

    public abstract int getSceneRasterHeight();

    public abstract float getTiePointGridOffsetX(int var1);

    public abstract float getTiePointGridOffsetY(int var1);

    public abstract float getTiePointSubSamplingX(int var1);

    public abstract float getTiePointSubSamplingY(int var1);

    public abstract boolean storesPixelsInChronologicalOrder();

    public abstract Mask[] createDefaultMasks(String var1);

    protected Mask mask(String name, String description, String expression, Color color, float transparency) {
        return Mask.BandMathsType.create((String)name, (String)description, (int)this.getSceneRasterWidth(), (int)this.getSceneRasterHeight(), (String)expression, (Color)color, (double)transparency);
    }

    public ImageInputStream getDataInputStream() {
        return this.dataInputStream;
    }

    public Date getSensingStart() {
        return this.sensingStart;
    }

    public Date getSensingStop() {
        return this.sensingStop;
    }

    public int getProductSize() {
        return this.productSize;
    }

    public Header getMPH() {
        return this.mph;
    }

    public Header getSPH() {
        return this.sph;
    }

    public int getNumDSDs() {
        return this.numDSDs;
    }

    public DSD getDSDAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.dsdArray[index];
    }

    public DSD getDSD(String datasetName) {
        String dsdName = DDDB.getInstance().getDSDName(this.getDddbProductType(), datasetName);
        for (DSD theDSD : this.dsdArray) {
            if (!theDSD.getDatasetName().equalsIgnoreCase(dsdName)) continue;
            return theDSD;
        }
        return null;
    }

    public int getDSDIndex(String datasetName) {
        String dsdName = DDDB.getInstance().getDSDName(this.getDddbProductType(), datasetName);
        int numDSDs = this.getNumDSDs();
        for (int i = 0; i < numDSDs; ++i) {
            if (!this.getDSDAt(i).getDatasetName().equalsIgnoreCase(dsdName)) continue;
            return i;
        }
        return -1;
    }

    public DSD[] getValidDSDs(char datasetType) {
        DSD[] dsds = null;
        for (int j = 0; j < 2; ++j) {
            int n = 0;
            for (int i = 0; i < this.getNumDSDs(); ++i) {
                DSD dsd = this.getDSDAt(i);
                if (dsd == null || dsd.getDatasetType() != datasetType || dsd.isDatasetEmpty()) continue;
                if (dsds != null) {
                    dsds[n] = dsd;
                }
                ++n;
            }
            if (j != 0) continue;
            dsds = new DSD[n];
        }
        return dsds;
    }

    public Record getGADS() {
        return this.gads;
    }

    public String[] getValidDatasetNames() throws IOException {
        return this.getValidDatasetNames(-1);
    }

    public String[] getValidDatasetNames(int datasetType) throws IOException {
        String[] datasetNames = DDDB.getInstance().getDatasetNames(this.getDddbProductType());
        ArrayList<String> nameList = new ArrayList<String>();
        for (String datasetName : datasetNames) {
            DSD dsd = this.getDSD(datasetName);
            if (dsd == null || dsd.isDatasetEmpty() || datasetType != -1 && datasetType != dsd.getDatasetType()) continue;
            nameList.add(datasetName);
        }
        String[] validDatasetNames = new String[nameList.size()];
        nameList.toArray(validDatasetNames);
        return validDatasetNames;
    }

    public boolean isValidDatasetName(String name) throws IOException {
        String[] datasetNames = this.getValidDatasetNames();
        return StringUtils.containsIgnoreCase((String[])datasetNames, (String)name);
    }

    public RecordReader getRecordReader(String datasetName) throws IOException, DDDBException {
        String datasetNameUC = datasetName.toUpperCase();
        RecordReader recordReader = this.recordReaderCache.get(datasetNameUC);
        if (recordReader != null) {
            return recordReader;
        }
        DSD dsd = this.getDSD(datasetName);
        if (dsd == null) {
            throw new IllegalFileFormatException("no DSD found for dataset with name '" + datasetName + "'");
        }
        RecordInfo recordInfo = this.readRecordInfo(datasetName);
        if (recordInfo == null) {
            throw new DDDBException("no record info found for dataset with name '" + datasetName + "'");
        }
        recordReader = this.lineInterleaved && dsd.getDatasetType() == 'M' ? new LineInterleavedRecordReader(this, dsd, recordInfo) : new RecordReader(this, dsd, recordInfo);
        this.recordReaderCache.put(datasetNameUC, recordReader);
        return recordReader;
    }

    protected RecordInfo readRecordInfo(String datasetName) {
        return DDDB.getInstance().readRecordInfo(this.getDddbProductType(), datasetName, this.parameters);
    }

    public ProductData.UTC getRecordTime(String datasetName, String timeFieldName, int recordIndex) throws IOException {
        RecordReader recordReader = this.getRecordReader(datasetName);
        Record record = recordReader.readRecord(recordIndex);
        Field timeField = record.getField(timeFieldName);
        ProductData data = timeField.getData();
        return data instanceof ProductData.UTC ? (ProductData.UTC)data : null;
    }

    public ProductData.UTC[] getAllRecordTimes() throws IOException {
        String[] datasetNames = this.getValidDatasetNames(77);
        RecordReader recordReader = this.getRecordReader(datasetNames[0]);
        int fieldIndex = recordReader.getRecordInfo().getFieldInfoIndex("dsr_time");
        long fieldOffset = recordReader.getRecordInfo().getFieldOffset(fieldIndex);
        FieldInfo dsrTime = recordReader.getRecordInfo().getFieldInfoAt(fieldIndex);
        int numRecords = recordReader.getNumRecords();
        ProductData.UTC[] recordTimes = new ProductData.UTC[numRecords];
        for (int i = 0; i < recordTimes.length; ++i) {
            Field field = dsrTime.createField();
            recordReader.readFieldSegment(i, fieldOffset, 1, 0, 2, field);
            recordTimes[i] = (ProductData.UTC)field.getData();
        }
        return recordTimes;
    }

    public String[] getBandNames() {
        BandLineReader[] bandLineReaders = this.getBandLineReaders();
        String[] bandNames = new String[bandLineReaders.length];
        for (int i = 0; i < bandNames.length; ++i) {
            bandNames[i] = bandLineReaders[i].getBandName();
        }
        return bandNames;
    }

    public String getAutoGroupingPattern() {
        return "";
    }

    public BandLineReader[] getBandLineReaders() {
        if (this.bandLineReaders == null) {
            this.bandLineReaders = this.createBandLineReaders();
        }
        return this.bandLineReaders;
    }

    protected BandLineReader[] createBandLineReaders() {
        return DDDB.getInstance().getBandLineReaders(this);
    }

    public synchronized BandLineReader getBandLineReader(Band band) {
        if (this.bandLineReaderMap == null) {
            this.bandLineReaderMap = new Hashtable<Band, BandLineReader>();
            BandLineReader[] bandLineReaders = this.getBandLineReaders();
            Product product = band.getProduct();
            for (BandLineReader bandLineReader : bandLineReaders) {
                String bandName = bandLineReader.getBandName();
                Band key = product.getBand(bandName);
                if (key == null) continue;
                this.bandLineReaderMap.put(key, bandLineReader);
            }
        }
        return this.bandLineReaderMap.get(band);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ImageInputStream imageInputStream = this.dataInputStream;
        synchronized (imageInputStream) {
            this.dataInputStream.close();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void postProcessMPH(Map parameters) throws IOException {
    }

    protected void postProcessSPH(Map parameters) throws IOException {
    }

    int getMappedMDSRIndex(int lineIndex) {
        return lineIndex;
    }

    double getMissingMDSRPixelValue() {
        return 0.0;
    }

    abstract void setInvalidPixelExpression(Band var1);

    protected DSD[] getDsds() {
        return this.dsdArray;
    }

    public abstract String getGADSName();

    public abstract float[] getSpectralBandWavelengths();

    public abstract float[] getSpectralBandBandwidths();

    public abstract float[] getSpectralBandSolarFluxes();

    public String[] getDefaultBitmaskNames(String bandName) {
        return null;
    }

    public BandInfo createBandInfo(String bandName, int dataType, int spectralBandIndex, int sampleModel, int scalingMethod, float scalingOffset, float scalingFactor, String validExpression, FlagCoding flagCoding, String physicalUnit, String description, String dataSetName) {
        return new BandInfo(bandName, dataType, spectralBandIndex, sampleModel, scalingMethod, scalingOffset, scalingFactor, validExpression, flagCoding, physicalUnit, description, this.getSceneRasterWidth(), this.getSceneRasterHeight());
    }

    public String updateExpression(String expression) {
        return expression;
    }

    public static ProductFile open(File file, ImageInputStream dataInputStream) throws IOException {
        return ProductFile.open(file, dataInputStream, false);
    }

    public static ProductFile open(File file, ImageInputStream dataInputStream, boolean lineInterleaved) throws IOException {
        Guardian.assertNotNull((String)"dataInputStream", (Object)dataInputStream);
        String productType = ProductFile.readProductType(dataInputStream);
        if (productType == null) {
            throw new ProductIOException("not an ENVISAT product or ENVISAT product type not supported");
        }
        String productTypeUC = productType.toUpperCase().substring(0, 9);
        ProductFile productFile = null;
        if (productTypeUC.startsWith("ME")) {
            productFile = new MerisProductFile(file, dataInputStream, lineInterleaved);
        } else if (productTypeUC.startsWith("AT")) {
            productFile = new AatsrProductFile(file, dataInputStream);
        } else if (productTypeUC.startsWith("AS") || productTypeUC.startsWith("SA")) {
            productFile = productTypeUC.startsWith("ASA_XCA") ? new AsarXCAProductFile(file, dataInputStream) : new AsarProductFile(file, dataInputStream);
        } else if (productTypeUC.startsWith("DOR")) {
            productFile = new DorisOrbitProductFile(file, dataInputStream);
        }
        if (productFile == null) {
            throw new ProductIOException("ENVISAT '" + productType + "' products are not supported");
        }
        return productFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        ImageInputStream imageInputStream = this.dataInputStream;
        synchronized (imageInputStream) {
            this.readMPH();
            this.postProcessMPH(this.parameters);
            this.readSPH();
            this.postProcessSPH(this.parameters);
        }
        this.traceDddbFieldSizeParameters();
        this.readGADS();
        this._productDescription = DDDB.getInstance().getProductDescription(this.getDddbProductType());
    }

    private void readMPH() throws IOException {
        Debug.assertTrue((this.mph == null ? 1 : 0) != 0);
        byte[] mphBytes = new byte[1247];
        this.dataInputStream.readFully(mphBytes);
        try {
            this.mph = HeaderParser.getInstance().parseHeader("MPH", mphBytes);
            Debug.trace((String)("ProductFile: " + this.mph));
            this.productId = this.mph.getParamString("PRODUCT");
            this.productSize = this.mph.getParamInt("TOT_SIZE");
            this.sphSize = this.mph.getParamInt("SPH_SIZE");
            this.dsdSize = this.mph.getParamInt("DSD_SIZE");
            this.numDSDs = this.mph.getParamInt("NUM_DSD");
            this.numDatasets = this.mph.getParamInt("NUM_DATA_SETS");
            try {
                this.sensingStart = this.mph.getParamDate(KEY_SENSING_START);
            }
            catch (HeaderParseException e) {
                this.getLogger().warning("failed to parse header parameter 'SENSING_START': " + e.getMessage() + this.file.getAbsolutePath());
            }
            try {
                this.sensingStop = this.mph.getParamDate(KEY_SENSING_STOP);
            }
            catch (HeaderParseException e) {
                this.getLogger().warning("failed to parse header parameter 'SENSING_STOP': " + e.getMessage());
            }
        }
        catch (HeaderParseException e) {
            throw new IllegalFileFormatException(e.getMessage());
        }
        this.productType = this.productId.substring(0, 10).toUpperCase();
        if (this.productType != null && this.productType.endsWith("C")) {
            this.productType = this.productType.substring(0, this.productType.length() - 1) + "P";
        }
        if (!this.productType.endsWith("P")) {
            String newType = this.productType.substring(0, 9) + "P";
            this.getLogger().warning("mapping to regular product type '" + newType + "' due to missing specification for products of type '" + this.productType + "'");
            this.productType = newType;
        }
    }

    private void readSPH() throws IOException {
        int dsdCountValid;
        Debug.assertTrue((this.sph == null ? 1 : 0) != 0);
        byte[] sphBytesAll = new byte[this.sphSize];
        this.dataInputStream.readFully(sphBytesAll);
        int sphSizeActual = ProductFile.getFirstDSDPos(sphBytesAll);
        byte[] sphBytes = new byte[sphSizeActual];
        System.arraycopy(sphBytesAll, 0, sphBytes, 0, sphSizeActual);
        try {
            this.sph = HeaderParser.getInstance().parseHeader("SPH", sphBytes);
            Debug.trace((String)("ProductFile: " + this.sph));
            dsdCountValid = 0;
            byte[] dsdBytes = new byte[this.dsdSize];
            this.dsdArray = new DSD[this.numDSDs];
            if (sphSizeActual + this.numDSDs * this.dsdSize > this.sphSize) {
                return;
            }
            for (int i = 0; i < this.numDSDs; ++i) {
                System.arraycopy(sphBytesAll, sphSizeActual + i * this.dsdSize, dsdBytes, 0, this.dsdSize);
                String dsdKey = "DSD(" + (i + 1) + ")";
                Header dsd = HeaderParser.getInstance().parseHeader(dsdKey, dsdBytes);
                String dsName = dsd.hasParam("DS_NAME") ? dsd.getParamString("DS_NAME") : "";
                String dsType = dsd.hasParam("DS_TYPE") ? dsd.getParamString("DS_TYPE") + "?" : "?";
                String filename = dsd.hasParam("FILENAME") ? dsd.getParamString("FILENAME") : "";
                long dsOffset = dsd.hasParam("DS_OFFSET") ? dsd.getParamUInt("DS_OFFSET") : 0L;
                long dsSize = dsd.hasParam("DS_SIZE") ? dsd.getParamUInt("DS_SIZE") : 0L;
                int numDsr = dsd.hasParam("NUM_DSR") ? dsd.getParamInt("NUM_DSR") : 0;
                int dsrSize = dsd.hasParam("DSR_SIZE") ? dsd.getParamInt("DSR_SIZE") : 0;
                this.dsdArray[i] = new DSD(i, dsName.trim(), dsType.charAt(0), filename.trim(), dsOffset, dsSize, numDsr, dsrSize);
                Debug.trace((String)("ProductFile: " + this.dsdArray[i]));
                ++dsdCountValid;
            }
        }
        catch (HeaderParseException e) {
            throw new IllegalFileFormatException(e.getMessage());
        }
        this.numDSDs = dsdCountValid;
        if (this.numDSDs < this.numDatasets) {
            StringBuffer message = new StringBuffer();
            message.append("unsufficient number of DSDs found: minimum should be ");
            message.append(this.numDatasets);
            message.append(", but found only ");
            message.append(this.numDSDs);
            this.getLogger().warning(message.toString());
        }
    }

    private void readGADS() throws IOException {
        this.gads = this.getGADSName() != null && this.isValidDatasetName(this.getGADSName()) ? this.getRecordReader(this.getGADSName()).readRecord() : null;
        Debug.trace((String)("ProductFile: GADS = " + this.gads));
    }

    static String readProductType(ImageInputStream dataInputStream) throws IOException {
        byte[] magicBytes = new byte["PRODUCT=\"".length() + 10];
        String productType = null;
        dataInputStream.seek(0L);
        dataInputStream.mark();
        dataInputStream.readFully(magicBytes);
        dataInputStream.reset();
        String magicString = new String(magicBytes).toUpperCase();
        if (magicString.startsWith("PRODUCT=\"")) {
            productType = magicString.substring("PRODUCT=\"".length());
        }
        if (productType != null && productType.endsWith("C")) {
            productType = productType.substring(0, productType.length() - 1) + "P";
        }
        return productType;
    }

    private static int getFirstDSDPos(byte[] sphBytes) {
        return new String(sphBytes).toUpperCase().indexOf("DS_NAME=");
    }

    private void traceDddbFieldSizeParameters() {
        Iterator it = this.parameters.keySet().iterator();
        Debug.trace((String)"ProductFile: DDDB field size parameters = {");
        while (it.hasNext()) {
            String name = it.next().toString();
            Object value = this.parameters.get(name);
            Debug.trace((String)("  " + name + " = " + value));
        }
        Debug.trace((String)"}");
    }

    protected void addCustomMetadata(Product product) throws IOException {
    }
}

