/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.esa.beam.dataio.envisat.DorisOrbitProductFile;
import org.esa.beam.dataio.envisat.EnvisatAuxReader;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.framework.dataio.IllegalFileFormatException;
import org.esa.beam.framework.datamodel.ProductData;

public class EnvisatOrbitReader
extends EnvisatAuxReader {
    private OrbitVector[] dataRecords = null;
    private double[] recordTimes = null;

    public void readOrbitData() throws IOException {
        if (this._productFile instanceof DorisOrbitProductFile) {
            int i;
            DorisOrbitProductFile dorisProdFile = (DorisOrbitProductFile)this._productFile;
            Record orbitRecord = dorisProdFile.readOrbitData();
            OrbitVector orb = null;
            ArrayList<OrbitVector> orbitVectorList = new ArrayList<OrbitVector>();
            int numFields = orbitRecord.getNumFields();
            for (i = 0; i < numFields; ++i) {
                Field f = orbitRecord.getFieldAt(i);
                String fieldName = f.getName();
                if (fieldName.contains("blank")) continue;
                if (fieldName.contains("utc_time")) {
                    orb = new OrbitVector();
                    try {
                        orb.utcTime = ProductData.UTC.parse((String)f.getData().getElemString()).getMJD();
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalFileFormatException("Failed to parse UTC time " + e.getMessage());
                    }
                }
                if (fieldName.contains("delta_ut1")) {
                    if (orb == null) continue;
                    orb.delta_ut1 = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("abs_orbit")) {
                    if (orb == null) continue;
                    orb.absOrbit = Integer.parseInt(f.getData().getElemString().replace("+", ""));
                    continue;
                }
                if (fieldName.contains("x_pos")) {
                    if (orb == null) continue;
                    orb.xPos = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("y_pos")) {
                    if (orb == null) continue;
                    orb.yPos = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("z_pos")) {
                    if (orb == null) continue;
                    orb.zPos = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("x_vel")) {
                    if (orb == null) continue;
                    orb.xVel = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("y_vel")) {
                    if (orb == null) continue;
                    orb.yVel = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (fieldName.contains("z_vel")) {
                    if (orb == null) continue;
                    orb.zVel = Double.parseDouble(f.getData().getElemString());
                    continue;
                }
                if (!fieldName.contains("qual_flags")) continue;
                if (orb != null) {
                    orb.qualFlags = f.getData().getElemString();
                }
                orbitVectorList.add(orb);
            }
            this.dataRecords = orbitVectorList.toArray(new OrbitVector[orbitVectorList.size()]);
            this.recordTimes = new double[this.dataRecords.length];
            for (i = 0; i < this.dataRecords.length; ++i) {
                this.recordTimes[i] = this.dataRecords[i].utcTime;
            }
        }
    }

    public OrbitVector getOrbitVector(int n) {
        return this.dataRecords[n];
    }

    public int getNumRecords() {
        return this.dataRecords.length;
    }

    public OrbitVector getOrbitVector(double utc) throws Exception {
        int itRel;
        int interpOrder = 8;
        int nRecords = this.recordTimes.length;
        double t0 = this.recordTimes[0];
        double tN = this.recordTimes[nRecords - 1];
        double tRel = (utc - t0) / (tN - t0) * (double)(nRecords - 1);
        int n0 = itRel = (int)Math.max(1L, Math.min(Math.round(tRel) - 4L, (long)(nRecords - 1 - 8)));
        int n1 = itRel + 1;
        int n2 = itRel + 2;
        int n3 = itRel + 3;
        int n4 = itRel + 4;
        int n5 = itRel + 5;
        int n6 = itRel + 6;
        int n7 = itRel + 7;
        int n8 = itRel + 8;
        if (n0 < 0 || n1 < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 > nRecords || n6 > nRecords || n7 > nRecords || n8 > nRecords) {
            throw new Exception("Incorrect UTC time");
        }
        double[] delta_ut1Array = new double[]{this.dataRecords[n0].delta_ut1, this.dataRecords[n1].delta_ut1, this.dataRecords[n2].delta_ut1, this.dataRecords[n3].delta_ut1, this.dataRecords[n4].delta_ut1, this.dataRecords[n5].delta_ut1, this.dataRecords[n6].delta_ut1, this.dataRecords[n7].delta_ut1, this.dataRecords[n8].delta_ut1};
        double[] xPosArray = new double[]{this.dataRecords[n0].xPos, this.dataRecords[n1].xPos, this.dataRecords[n2].xPos, this.dataRecords[n3].xPos, this.dataRecords[n4].xPos, this.dataRecords[n5].xPos, this.dataRecords[n6].xPos, this.dataRecords[n7].xPos, this.dataRecords[n8].xPos};
        double[] yPosArray = new double[]{this.dataRecords[n0].yPos, this.dataRecords[n1].yPos, this.dataRecords[n2].yPos, this.dataRecords[n3].yPos, this.dataRecords[n4].yPos, this.dataRecords[n5].yPos, this.dataRecords[n6].yPos, this.dataRecords[n7].yPos, this.dataRecords[n8].yPos};
        double[] zPosArray = new double[]{this.dataRecords[n0].zPos, this.dataRecords[n1].zPos, this.dataRecords[n2].zPos, this.dataRecords[n3].zPos, this.dataRecords[n4].zPos, this.dataRecords[n5].zPos, this.dataRecords[n6].zPos, this.dataRecords[n7].zPos, this.dataRecords[n8].zPos};
        double[] xVelArray = new double[]{this.dataRecords[n0].xVel, this.dataRecords[n1].xVel, this.dataRecords[n2].xVel, this.dataRecords[n3].xVel, this.dataRecords[n4].xVel, this.dataRecords[n5].xVel, this.dataRecords[n6].xVel, this.dataRecords[n7].xVel, this.dataRecords[n8].xVel};
        double[] yVelArray = new double[]{this.dataRecords[n0].yVel, this.dataRecords[n1].yVel, this.dataRecords[n2].yVel, this.dataRecords[n3].yVel, this.dataRecords[n4].yVel, this.dataRecords[n5].yVel, this.dataRecords[n6].yVel, this.dataRecords[n7].yVel, this.dataRecords[n8].yVel};
        double[] zVelArray = new double[]{this.dataRecords[n0].zVel, this.dataRecords[n1].zVel, this.dataRecords[n2].zVel, this.dataRecords[n3].zVel, this.dataRecords[n4].zVel, this.dataRecords[n5].zVel, this.dataRecords[n6].zVel, this.dataRecords[n7].zVel, this.dataRecords[n8].zVel};
        OrbitVector orb = new OrbitVector();
        double ref = tRel - (double)itRel;
        orb.utcTime = utc;
        orb.absOrbit = this.dataRecords[n1].absOrbit;
        orb.qualFlags = this.dataRecords[n1].qualFlags;
        orb.delta_ut1 = EnvisatOrbitReader.lagrangeEightOrderInterpolation(delta_ut1Array, ref);
        orb.xPos = EnvisatOrbitReader.lagrangeEightOrderInterpolation(xPosArray, ref);
        orb.yPos = EnvisatOrbitReader.lagrangeEightOrderInterpolation(yPosArray, ref);
        orb.zPos = EnvisatOrbitReader.lagrangeEightOrderInterpolation(zPosArray, ref);
        orb.xVel = EnvisatOrbitReader.lagrangeEightOrderInterpolation(xVelArray, ref);
        orb.yVel = EnvisatOrbitReader.lagrangeEightOrderInterpolation(yVelArray, ref);
        orb.zVel = EnvisatOrbitReader.lagrangeEightOrderInterpolation(zVelArray, ref);
        return orb;
    }

    public static double lagrangeInterpolatingPolynomial(double[] pos, double[] val, double desiredPos) throws Exception {
        if (pos.length != val.length) {
            throw new Exception("Incorrect array length");
        }
        double retVal = 0.0;
        for (int i = 0; i < pos.length; ++i) {
            double weight = 1.0;
            for (int j = 0; j < pos.length; ++j) {
                if (j == i) continue;
                weight *= (desiredPos - pos[j]) / (pos[i] - pos[j]);
            }
            retVal += weight * val[i];
        }
        return retVal;
    }

    public static double lagrangeEightOrderInterpolation(double[] samples, double x) {
        double out = 0.0;
        double[] denominators = new double[]{40320.0, -5040.0, 1440.0, -720.0, 576.0, -720.0, 1440.0, -5040.0, 40320.0};
        double numerator = x * (x - 1.0) * (x - 2.0) * (x - 3.0) * (x - 4.0) * (x - 5.0) * (x - 6.0) * (x - 7.0) * (x - 8.0);
        if (numerator == 0.0) {
            return samples[(int)Math.round(x)];
        }
        for (int i = 0; i < samples.length; ++i) {
            double coeff = numerator / denominators[i] / (x - (double)i);
            out += coeff * samples[i];
        }
        return out;
    }

    public static EnvisatOrbitReader getInstance() {
        return Holder.instance;
    }

    private static class Holder {
        private static final EnvisatOrbitReader instance = new EnvisatOrbitReader();

        private Holder() {
        }
    }

    public static final class OrbitVector {
        public double utcTime = 0.0;
        public double delta_ut1 = 0.0;
        public int absOrbit = 0;
        public double xPos = 0.0;
        public double yPos = 0.0;
        public double zPos = 0.0;
        public double xVel = 0.0;
        public double yVel = 0.0;
        public double zVel = 0.0;
        public String qualFlags = null;
    }
}

