/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.envisat.DDDB;
import org.esa.beam.dataio.envisat.DSD;
import org.esa.beam.dataio.envisat.EnvisatProductReader;
import org.esa.beam.dataio.envisat.ForwardingProductFile;
import org.esa.beam.dataio.envisat.Header;
import org.esa.beam.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.framework.dataio.IllegalFileFormatException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.StringUtils;

public class AsarXCAProductFile
extends ForwardingProductFile {
    private static final String GADS_NAME = "auxiliary_data";
    private IODD _ioddVersion = IODD.VERSION_UNKNOWN;
    private static final String IODD4A_SUFFIX = "_IODD_4A";

    protected AsarXCAProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public String getGADSName() {
        return GADS_NAME;
    }

    @Override
    protected void postProcessMPH(Map parameters) throws IOException {
        this._ioddVersion = IODD.VERSION_UNKNOWN;
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
        DSD[] mdsDsds = this.getValidDSDs('G');
        if (mdsDsds.length == 0) {
            throw new IllegalFileFormatException("no valid global annotation datasets found in this ASAR product");
        }
        this.setIODDVersion();
    }

    @Override
    public String getProductType() {
        return this.getProductId().substring(0, 10).toUpperCase();
    }

    @Override
    public boolean isValidDatasetName(String name) throws IOException {
        String[] datasetNames = this.getValidDatasetNames();
        return name.equalsIgnoreCase(this.getGADSName()) || StringUtils.containsIgnoreCase((String[])datasetNames, (String)name);
    }

    IODD getIODDVersion() {
        if (this._ioddVersion == IODD.VERSION_UNKNOWN) {
            this.setIODDVersion();
        }
        return this._ioddVersion;
    }

    private void setIODDVersion() {
        Header mph = this.getMPH();
        try {
            String refDoc = mph.getParamString("REF_DOC").toUpperCase().trim();
            if (refDoc.endsWith("4A") || refDoc.endsWith("4/A")) {
                this._ioddVersion = IODD.ASAR_4A;
            } else {
                int issue;
                char issueCh = refDoc.charAt(refDoc.length() - 2);
                if (Character.isDigit(issueCh) && (issue = Character.getNumericValue(issueCh)) >= 4) {
                    this._ioddVersion = IODD.ASAR_4A;
                }
            }
        }
        catch (HeaderEntryNotFoundException e) {
            this._ioddVersion = IODD.VERSION_UNKNOWN;
        }
    }

    @Override
    protected String getDddbProductType() {
        String productType = AsarXCAProductFile.getDddbProductTypeReplacement(this.getProductType(), this.getIODDVersion());
        return productType != null ? productType : super.getDddbProductType();
    }

    static String getDddbProductTypeReplacement(String productType, IODD ioddVersion) {
        String resource = productType;
        if (ioddVersion == IODD.ASAR_4A && AsarXCAProductFile.productDDExists(productType + IODD4A_SUFFIX)) {
            resource = productType + IODD4A_SUFFIX;
        }
        return resource;
    }

    private static boolean productDDExists(String productType) {
        String productInfoFilePath = "products/" + productType + ".dd";
        return DDDB.databaseResourceExists(productInfoFilePath);
    }

    @Override
    public void setInvalidPixelExpression(Band band) {
        band.setNoDataValueUsed(false);
        band.setNoDataValue(0.0);
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        MetadataElement root = product.getMetadataRoot();
        Record gads = this.getGADS();
        MetadataElement elem = EnvisatProductReader.createMetadataGroup("XCA", gads);
        root.addElement(elem);
    }

    static enum IODD {
        VERSION_UNKNOWN,
        ASAR_4A;

    }
}

