/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.TestNotExecutableException;
import org.esa.beam.dataio.envisat.DDDB;
import org.esa.beam.dataio.envisat.DDDBException;
import org.esa.beam.dataio.envisat.RecordInfo;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;

public class DDDBTest
extends TestCase {
    private DDDB _dddb;

    public DDDBTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        if (DDDB.isInstalled()) {
            return new TestSuite(DDDBTest.class);
        }
        return new TestCase(DDDBTest.class.getName()){

            public void runTest() {
                System.out.println();
                System.out.println(DDDBTest.class + ": warning: test will not be performed: DDDB not installed: ");
                System.out.println("/org/esa/beam/resources/dddb");
            }
        };
    }

    protected void setUp() {
        this._dddb = DDDB.getInstance();
    }

    protected void tearDown() {
        this._dddb = null;
    }

    public void testGetDatasetNames() {
        try {
            DDDBTest.assertEquals((String)"Radiance_9", (String)this._dddb.getDatasetNames("MER_RR__1P")[11]);
            DDDBTest.assertEquals((String)"Radiance_9", (String)this._dddb.getDatasetNames("MER_FR__1P")[11]);
            DDDBTest.assertEquals((String)"Chl_1_TOAVI_CTP", (String)this._dddb.getDatasetNames("MER_RR__2P")[17]);
            DDDBTest.assertEquals((String)"Chl_1_TOAVI_CTP", (String)this._dddb.getDatasetNames("MER_FR__2P")[17]);
            DDDBTest.assertEquals((String)"Cloud_Type_OT", (String)this._dddb.getDatasetNames("MER_LRC_2P")[3]);
            DDDBTest.assertEquals((String)"Vapour_Content", (String)this._dddb.getDatasetNames("MER_RRC_2P")[5]);
            DDDBTest.assertEquals((String)"BOAVI", (String)this._dddb.getDatasetNames("MER_RRV_2P")[4]);
            DDDBTest.assertEquals((String)"VISIBLE_CALIB_COEFS_GADS", (String)this._dddb.getDatasetNames("ATS_TOA_1P")[5]);
            DDDBTest.assertEquals((String)"DISTRIB_SST_CLOUD_LAND_MDS", (String)this._dddb.getDatasetNames("ATS_NR__2P")[7]);
            try {
                this._dddb.getDatasetNames("not a product");
                DDDBTest.fail((String)"DDDBException expected");
            }
            catch (DDDBException e) {
                // empty catch block
            }
            try {
                this._dddb.getDatasetNames(null);
                DDDBTest.fail((String)"IllegalArgumentException expected");
            }
            catch (IllegalArgumentException e) {}
        }
        catch (DDDBException e) {
            throw new TestNotExecutableException((Exception)((Object)e));
        }
    }

    public void testReadRecordInfo() {
        try {
            Hashtable<String, Integer> params = new Hashtable<String, Integer>();
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "Quality_ADS", null));
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "QUALITY_ADS", null));
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "Scaling_Factor_GADS", null));
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "SCALING_FACTOR_GADS", null));
            params.put("tiePointGridWidth", new Integer(71));
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "Tie_points_ADS", params));
            DDDBTest.assertNotNull((Object)this._dddb.readRecordInfo("MER_RR__1P", "TIE_POINTS_ADS", params));
            try {
                this._dddb.readRecordInfo("MER_RR__1P", "not a dataset", null);
                DDDBTest.fail((String)"DDDBException expected");
            }
            catch (DDDBException e) {
                // empty catch block
            }
            try {
                this._dddb.readRecordInfo("not a product", "not a dataset", null);
                DDDBTest.fail((String)"DDDBException expected");
            }
            catch (DDDBException e) {
                // empty catch block
            }
            try {
                this._dddb.readRecordInfo("MER_RR__1P", null, null);
                DDDBTest.fail((String)"IllegalArgumentException expected");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this._dddb.readRecordInfo(null, "not a dataset", null);
                DDDBTest.fail((String)"IllegalArgumentException expected");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (DDDBException e) {
            throw new TestNotExecutableException((Exception)((Object)e));
        }
    }

    public void testDataIntegrity() {
        try {
            Hashtable<String, Integer> params = new Hashtable<String, Integer>();
            params.put("tiePointGridWidth", new Integer(71));
            params.put("sceneRasterWidth", new Integer(1121));
            this.testDataBaseIntegrity("MER_RR__1P", "Quality_ADS", params, 4, 33);
            this.testDataBaseIntegrity("MER_RR__1P", "Scaling_Factor_GADS", params, 12, 292);
            this.testDataBaseIntegrity("MER_RR__1P", "Tie_points_ADS", params, 17, 3563);
            this.testDataBaseIntegrity("MER_RR__1P", "Radiance_9", params, 3, 2255);
            this.testDataBaseIntegrity("MER_RR__1P", "Flags", params, 4, 3376);
            params.put("tiePointGridWidth", new Integer(36));
            params.put("sceneRasterWidth", new Integer(2241));
            this.testDataBaseIntegrity("MER_FR__1P", "Quality_ADS", params, 4, 33);
            this.testDataBaseIntegrity("MER_FR__1P", "Scaling_Factor_GADS", params, 12, 292);
            this.testDataBaseIntegrity("MER_FR__1P", "Tie_points_ADS", params, 17, 1813);
            this.testDataBaseIntegrity("MER_FR__1P", "Radiance_9", params, 3, 4495);
            this.testDataBaseIntegrity("MER_FR__1P", "Flags", params, 4, 6736);
        }
        catch (DDDBException e) {
            throw new TestNotExecutableException((Exception)((Object)e));
        }
    }

    private void testDataBaseIntegrity(String productType, String datasetName, Map params, int numFieldsExpected, int sizeInBytesExpected) throws DDDBException {
        RecordInfo info = this._dddb.readRecordInfo(productType, datasetName, params);
        String msg = "prd='" + productType + "',ds='" + datasetName + "',params=" + params;
        DDDBTest.assertNotNull((String)msg, (Object)info);
        DDDBTest.assertEquals((String)msg, (int)numFieldsExpected, (int)info.getNumFieldInfos());
        DDDBTest.assertEquals((String)msg, (int)sizeInBytesExpected, (int)info.getSizeInBytes());
    }

    public void testThatAllFieldTypesAreRecognized() {
        DDDBTest.assertEquals((int)10, (int)DDDB.getFieldType((String)"SChar"));
        DDDBTest.assertEquals((int)20, (int)DDDB.getFieldType((String)"UChar"));
        DDDBTest.assertEquals((int)11, (int)DDDB.getFieldType((String)"SShort"));
        DDDBTest.assertEquals((int)21, (int)DDDB.getFieldType((String)"UShort"));
        DDDBTest.assertEquals((int)12, (int)DDDB.getFieldType((String)"SLong"));
        DDDBTest.assertEquals((int)22, (int)DDDB.getFieldType((String)"ULong"));
        DDDBTest.assertEquals((int)30, (int)DDDB.getFieldType((String)"Float"));
        DDDBTest.assertEquals((int)31, (int)DDDB.getFieldType((String)"Double"));
        DDDBTest.assertEquals((int)41, (int)DDDB.getFieldType((String)"String"));
        DDDBTest.assertEquals((int)51, (int)DDDB.getFieldType((String)"@/types/UTC.dd"));
        DDDBTest.assertEquals((int)41, (int)DDDB.getFieldType((String)"string"));
        DDDBTest.assertEquals((int)41, (int)DDDB.getFieldType((String)"STRING"));
        DDDBTest.assertEquals((int)0, (int)DDDB.getFieldType((String)"String "));
        try {
            DDDB.getFieldType(null);
            DDDBTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        DDDBTest.assertEquals((String)"SChar", (String)DDDB.getFieldTypeName((int)10));
        DDDBTest.assertEquals((String)"UChar", (String)DDDB.getFieldTypeName((int)20));
        DDDBTest.assertEquals((String)"SShort", (String)DDDB.getFieldTypeName((int)11));
        DDDBTest.assertEquals((String)"UShort", (String)DDDB.getFieldTypeName((int)21));
        DDDBTest.assertEquals((String)"SLong", (String)DDDB.getFieldTypeName((int)12));
        DDDBTest.assertEquals((String)"ULong", (String)DDDB.getFieldTypeName((int)22));
        DDDBTest.assertEquals((String)"Float", (String)DDDB.getFieldTypeName((int)30));
        DDDBTest.assertEquals((String)"Double", (String)DDDB.getFieldTypeName((int)31));
        DDDBTest.assertEquals((String)"String", (String)DDDB.getFieldTypeName((int)41));
        DDDBTest.assertEquals((String)"@/types/UTC.dd", (String)DDDB.getFieldTypeName((int)51));
        DDDBTest.assertEquals((String)"?", (String)DDDB.getFieldTypeName((int)0));
        try {
            DDDB.getFieldTypeName((int)32985);
            DDDBTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetInstance() {
        DDDBTest.assertNotNull((Object)DDDB.getInstance());
        DDDBTest.assertSame((Object)this._dddb, (Object)DDDB.getInstance());
    }

    public void testMERIS_L2_Flags_IODD7() {
        FlagCoding flagCoding = this._dddb.readFlagsCoding("l2_flags", "flags/MER_RR__2P_flags_IODD7.dd");
        DDDBTest.assertNotNull((Object)flagCoding);
        DDDBTest.assertEquals((int)0, (int)flagCoding.getNumElements());
        DDDBTest.assertEquals((int)31, (int)flagCoding.getNumAttributes());
        MetadataAttribute[] attributes = flagCoding.getAttributes();
        String[] expectedNames = new String[]{"LAND", "CLOUD", "WATER", "PCD_1_13", "PCD_14", "PCD_15", "PCD_16", "PCD_17", "PCD_18", "PCD_19", "COASTLINE", "COSMETIC", "SUSPECT", "OOADB", "ABSOA_DUST", "CASE2_S", "CASE2_ANOM", "TOAVI_BRIGHT", "CASE2_Y", "TOAVI_BAD", "ICE_HAZE", "TOAVI_CSI", "MEDIUM_GLINT", "TOAVI_WS", "LARS_ON", "BPAC_ON", "HIGH_GLINT", "TOAVI_INVAL_REC", "LOW_SUN", "LOW_PRESSURE", "WHITE_SCATTERER"};
        int[] expectedValues = new int[]{0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 0x200100, 0x200080, 0x800080, 0x200040, 0x800040, 0x200020, 0x800020, 0x200010, 0x800010, 0x800008, 0x200008, 0x200004, 0x800004, 2, 1, 0x200001};
        for (int i = 0; i < attributes.length; ++i) {
            MetadataAttribute attribute = attributes[i];
            String s = "at index [" + i + "]";
            DDDBTest.assertNotNull((String)s, (Object)attribute);
            DDDBTest.assertEquals((String)s, (String)expectedNames[i], (String)attribute.getName());
            DDDBTest.assertEquals((String)s, (long)1L, (long)attribute.getNumDataElems());
            DDDBTest.assertEquals((String)s, (int)expectedValues[i], (int)attribute.getData().getElemInt());
        }
    }

    public void testMERIS_L2_Flags() {
        FlagCoding flagCoding = this._dddb.readFlagsCoding("l2_flags", "flags/MER_RR__2P_flags.dd");
        DDDBTest.assertNotNull((Object)flagCoding);
        DDDBTest.assertEquals((int)0, (int)flagCoding.getNumElements());
        DDDBTest.assertEquals((int)31, (int)flagCoding.getNumAttributes());
        MetadataAttribute[] attributes = flagCoding.getAttributes();
        String[] expectedNames = new String[]{"LAND", "CLOUD", "WATER", "PCD_1_13", "PCD_14", "PCD_15", "PCD_16", "PCD_17", "PCD_18", "PCD_19", "COASTLINE", "COSMETIC", "SUSPECT", "OOADB", "ABSOA_DUST", "CASE2_S", "SNOW_ICE", "CASE2_ANOM", "TOAVI_BRIGHT", "CASE2_Y", "TOAVI_BAD", "ICE_HAZE", "TOAVI_CSI", "MEDIUM_GLINT", "TOAVI_WS", "DDV", "BPAC_ON", "HIGH_GLINT", "TOAVI_INVAL_REC", "LOW_SUN", "WHITE_SCATTERER"};
        int[] expectedValues = new int[]{0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 0x200100, 0x800100, 0x200080, 0x800080, 0x200040, 0x800040, 0x200020, 0x800020, 0x200010, 0x800010, 0x800008, 0x200008, 0x200004, 0x800004, 2, 0x200001};
        for (int i = 0; i < attributes.length; ++i) {
            MetadataAttribute attribute = attributes[i];
            String s = "at index [" + i + "]";
            DDDBTest.assertNotNull((String)s, (Object)attribute);
            DDDBTest.assertEquals((String)s, (String)expectedNames[i], (String)attribute.getName());
            DDDBTest.assertEquals((String)s, (long)1L, (long)attribute.getNumDataElems());
            DDDBTest.assertEquals((String)s, (int)expectedValues[i], (int)attribute.getData().getElemInt());
        }
    }
}

