/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.util.Vector;
import org.esa.beam.dataio.envisat.FieldInfo;
import org.esa.beam.dataio.envisat.ItemInfo;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.util.Guardian;

public final class RecordInfo
extends ItemInfo {
    private int _sizeInBytes = 0;
    private final Vector _fieldInfos = new Vector();

    RecordInfo(String recordName) {
        super(recordName, null);
    }

    public Record createRecord() {
        return Record.create(this);
    }

    public final int getSizeInBytes() {
        return this._sizeInBytes;
    }

    public final int getNumFieldInfos() {
        return this._fieldInfos.size();
    }

    public final FieldInfo getFieldInfoAt(int index) {
        return (FieldInfo)this._fieldInfos.elementAt(index);
    }

    public final FieldInfo getFieldInfo(String fieldName) {
        int index = this.getFieldInfoIndex(fieldName);
        return index >= 0 ? this.getFieldInfoAt(index) : null;
    }

    public final int getFieldInfoIndex(String fieldName) {
        Guardian.assertNotNull((String)"fieldName", (Object)fieldName);
        int n = this.getNumFieldInfos();
        for (int i = 0; i < n; ++i) {
            if (!this.getFieldInfoAt(i).isNameEqualTo(fieldName)) continue;
            return i;
        }
        return -1;
    }

    final void add(String fieldName, int dataType, int numElemns, String unit, String description) {
        this.add(new FieldInfo(fieldName, dataType, numElemns, unit, description));
    }

    final void add(FieldInfo fieldInfo) {
        Guardian.assertNotNull((String)"fieldInfo", (Object)fieldInfo);
        this.checkName(fieldInfo.getName());
        this._fieldInfos.addElement(fieldInfo);
        this.updateSizeInBytes();
    }

    final void add(RecordInfo subRecord, String prefix) {
        for (int numFields = 0; numFields < subRecord.getNumFieldInfos(); ++numFields) {
            FieldInfo f = subRecord.getFieldInfoAt(numFields);
            this._fieldInfos.addElement(new FieldInfo(prefix + '.' + f.getName(), f.getDataType(), f.getNumDataElems(), f.getPhysicalUnit(), f.getDescription()));
        }
    }

    final void add(RecordInfo recordInfo) {
        Guardian.assertNotNull((String)"recordInfo", (Object)recordInfo);
        for (int n = 0; n < recordInfo.getNumFieldInfos(); ++n) {
            this.add(recordInfo.getFieldInfoAt(n));
        }
    }

    void updateSizeInBytes() {
        this._sizeInBytes = 0;
        int n = this.getNumFieldInfos();
        for (int i = 0; i < n; ++i) {
            this._sizeInBytes += this.getFieldInfoAt(i).getSizeInBytes();
        }
    }

    public long getFieldOffset(int fieldIndex) {
        long offset = 0L;
        for (int i = 0; i < fieldIndex; ++i) {
            FieldInfo fieldInfo = this.getFieldInfoAt(i);
            offset += (long)fieldInfo.getSizeInBytes();
        }
        return offset;
    }

    @Override
    public String toString() {
        int n = this.getNumFieldInfos();
        StringBuffer sb = new StringBuffer(32 + 32 * n);
        sb.append("RecordInfo['");
        sb.append(this.getName());
        sb.append("',");
        sb.append(this.getSizeInBytes());
        sb.append(",\n");
        for (int i = 0; i < n; ++i) {
            sb.append("  ");
            sb.append(this.getFieldInfoAt(i).toString());
            if (i < n - 1) {
                sb.append(',');
            }
            sb.append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setNamePrefix(String prefix) {
        FieldInfo info = null;
        for (int n = 0; n < this._fieldInfos.size(); ++n) {
            info = (FieldInfo)this._fieldInfos.elementAt(n);
            info.setNamePrefix(prefix);
        }
    }

    private void checkName(String name) {
        int n = this.getNumFieldInfos();
        for (int i = 0; i < n; ++i) {
            if (!this.getFieldInfoAt(i).isNameEqualTo(name)) continue;
            throw new IllegalArgumentException("a field with the given name '" + name + "' already exists here");
        }
    }
}

