/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.envisat.BandInfo;
import org.esa.beam.dataio.envisat.DSD;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.ProductFile;
import org.esa.beam.framework.dataio.IllegalFileFormatException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;

public class MerisProductFile
extends ProductFile {
    public static final String RR__1_PREFIX = "MER_RR__1";
    public static final String RR__2_PREFIX = "MER_RR__2";
    public static final String FR__1_PREFIX = "MER_FR__1";
    public static final String FR__2_PREFIX = "MER_FR__2";
    public static final String FRS_1_PREFIX = "MER_FRS_1";
    public static final String FRS_2_PREFIX = "MER_FRS_2";
    public static final String FSG_1_PREFIX = "MER_FSG_1";
    public static final String IODD5_SUFFIX = "_IODD5";
    public static final String IODD6_SUFFIX = "_IODD6";
    public static final String IODD7_SUFFIX = "_IODD7";
    public static final String BITMASKDEF_NAME_LAND = "land";
    public static final String BITMASKDEF_NAME_WATER = "water";
    public static final String BITMASKDEF_NAME_COASTLINE = "coastline";
    public static final String BITMASKDEF_NAME_COSMETIC = "cosmetic";
    public static final String BITMASKDEF_NAME_DUPLICATED = "duplicated";
    public static final String BITMASKDEF_NAME_GLINT_RISK = "glint_risk";
    public static final String BITMASKDEF_NAME_SUSPECT = "suspect";
    public static final String BITMASKDEF_NAME_BRIGHT = "bright";
    public static final String BITMASKDEF_NAME_INVALID = "invalid";
    public static final String BITMASKDEF_NAME_CLOUD = "cloud";
    public static final String BITMASKDEF_NAME_INVALID_REFLECTANCES = "invalid_reflectances";
    public static final String BITMASKDEF_NAME_INVALID_WATER_VAPOUR = "invalid_water_vapour";
    public static final String BITMASKDEF_NAME_INVALID_ALGAL_1 = "invalid_algal_1";
    public static final String BITMASKDEF_NAME_INVALID_ALGAL2_TSM_YS = "invalid_algal2_tsm_ys";
    public static final String BITMASKDEF_NAME_INVALID_PHOTOSYN_RAD = "invalid_photosyn_rad";
    public static final String BITMASKDEF_NAME_INVALID_TOA_VEG = "invalid_toa_veg";
    public static final String BITMASKDEF_NAME_INVALID_BOA_VEG = "invalid_boa_veg";
    public static final String BITMASKDEF_NAME_INVALID_RECT_REFL = "invalid_rect_refl";
    public static final String BITMASKDEF_NAME_INVALID_SURF_PRESS = "invalid_surf_press";
    public static final String BITMASKDEF_NAME_INVALID_AERO_PRODUCTS = "invalid_aero_products";
    public static final String BITMASKDEF_NAME_INVALID_CLOUD_ALBEDO = "invalid_cloud_albedo";
    public static final String BITMASKDEF_NAME_INVALID_CLOUD_OPT_THICK_AND_TYPE = "invalid_cloud_opt_thick_and_type";
    public static final String BITMASKDEF_NAME_INVALID_CLOUD_TOP_PRESS = "invalid_cloud_top_press";
    public static final String BITMASKDEF_NAME_HIGH_GLINT = "high_glint";
    public static final String BITMASKDEF_NAME_MEDIUM_GLINT = "medium_glint";
    public static final String BITMASKDEF_NAME_ICE_HAZE = "ice_haze";
    public static final String BITMASKDEF_NAME_ABSOA_CONT = "absoa_cont";
    public static final String BITMASKDEF_NAME_ABSOA_DUST = "absoa_dust";
    public static final String BITMASKDEF_NAME_SNOW_ICE = "snow_ice";
    public static final String BITMASKDEF_NAME_CASE2_S = "case2_s";
    public static final String BITMASKDEF_NAME_CASE2_ANOM = "case2_anom";
    public static final String BITMASKDEF_NAME_CASE2_Y = "case2_y";
    public static final String BITMASKDEF_NAME_DARK_VEGETATION = "dark_vegetation";
    public static final String BITMASKDEF_NAME_UNCERTAIN_AEROSOL_MODEL = "uncertain_aerosol_model";
    public static final String BITMASKDEF_NAME_TOAVI_BRIGHT = "toavi_bright";
    public static final String BITMASKDEF_NAME_TOAVI_BAD = "toavi_bad";
    public static final String BITMASKDEF_NAME_TOAVI_CSI = "toavi_csi";
    public static final String BITMASKDEF_NAME_TOAVI_WS = "toavi_ws";
    public static final String BITMASKDEF_NAME_TOAVI_INVAL_REC = "toavi_inval_rec";
    public static final String BITMASKDEF_NAME_P_CONFIDENCE = "p_confidence";
    public static final String BITMASKDEF_NAME_LOW_PRESSURE = "low_pressure";
    public static final String BITMASKDEF_NAME_WHITE_SCATTERER = "white_scatterer";
    public static final String BITMASKDEF_NAME_PCD_1_13 = "pcd_1_13";
    public static final String BITMASKDEF_NAME_PCD_14 = "pcd_14";
    public static final String BITMASKDEF_NAME_PCD_15 = "pcd_15";
    public static final String BITMASKDEF_NAME_PCD_16 = "pcd_16";
    public static final String BITMASKDEF_NAME_PCD_17 = "pcd_17";
    public static final String BITMASKDEF_NAME_PCD_18 = "pcd_18";
    public static final String BITMASKDEF_NAME_PCD_19 = "pcd_19";
    public static final String BITMASKDEF_NAME_LOW_SUN = "low_sun";
    public static final String BITMASKDEF_NAME_BLUE_AERO = "blue_aero";
    public static final String BITMASKDEF_NAME_LAND_AEROSOL_ON = "land_aerosol_on";
    public static final String BITMASKDEF_NAME_DENSE_DARK_VEG = "dense_dark_veg";
    public static final String BITMASKDEF_NAME_BPAC_ON = "bpac_on";
    public static final int IODD_VERSION_UNKNOWN = -1;
    public static final int IODD_VERSION_5 = 5;
    public static final int IODD_VERSION_6 = 6;
    public static final int IODD_VERSION_7 = 7;
    public static final int IODD_VERSION_8 = 8;
    private ProductData.UTC _sceneRasterStartTime;
    private ProductData.UTC _sceneRasterStopTime;
    private int _sceneRasterWidth;
    private int _sceneRasterHeight;
    private int _tiePointSubSamplingX;
    private int _tiePointSubSamplingY;
    private int _ioddVersion;

    protected MerisProductFile(File file, ImageInputStream dataInputStream, boolean lineInterleaved) throws IOException {
        super(file, dataInputStream, lineInterleaved);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        return this._sceneRasterStartTime;
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        return this._sceneRasterStopTime;
    }

    @Override
    public int getSceneRasterWidth() {
        return this._sceneRasterWidth;
    }

    @Override
    public int getSceneRasterHeight() {
        return this._sceneRasterHeight;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return 0.5f;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return 0.5f;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return this._tiePointSubSamplingX;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return this._tiePointSubSamplingY;
    }

    @Override
    public String getGADSName() {
        return "Scaling_Factor_GADS";
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return true;
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        Field field = this.getSPH().getParam("BAND_WAVELEN");
        return this.createFloatArray(field, 0.001f);
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        Field field = this.getSPH().getParam("BANDWIDTH");
        return this.createFloatArray(field, 0.001f);
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        Field field = this.getGADS() != null ? this.getGADS().getField("sun_spec_flux") : null;
        return this.createFloatArray(field, 1.0f);
    }

    @Override
    protected void postProcessMPH(Map parameters) throws IOException {
        this._ioddVersion = -1;
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
        String[] validDatasetNames = this.getValidDatasetNames(77);
        if (validDatasetNames.length == 0) {
            throw new IllegalFileFormatException("no valid datasets found in this MERIS product");
        }
        String firstMDSName = validDatasetNames[0];
        DSD dsdFirstMDS = this.getDSD(firstMDSName);
        this._sceneRasterHeight = dsdFirstMDS.getNumRecords();
        this._sceneRasterWidth = this.getSPH().getParamInt("LINE_LENGTH");
        this._tiePointSubSamplingX = this.getSPH().getParamInt("SAMPLES_PER_TIE_PT");
        this._tiePointSubSamplingY = this.getSPH().getParamInt("LINES_PER_TIE_PT");
        int tiePointGridWidth = 1 + this._sceneRasterWidth / this._tiePointSubSamplingX;
        int tiePointGridHeight = 1 + this._sceneRasterHeight / this._tiePointSubSamplingY;
        DSD dsdTiePointsADS = this.getDSD("Tie_points_ADS");
        if (dsdTiePointsADS == null) {
            throw new IllegalFileFormatException("invalid product: missing DSD for dataset 'Tie_points_ADS'");
        }
        int numTiePointLinesFound = dsdTiePointsADS.getNumRecords();
        if (numTiePointLinesFound > tiePointGridHeight) {
            Debug.trace((String)"WARNING: found more tie point records than required:");
            Debug.trace((String)("WARNING: product: " + this.getProductId()));
            tiePointGridHeight = numTiePointLinesFound;
        } else if (numTiePointLinesFound < tiePointGridHeight) {
            Debug.trace((String)"WARNING: found less tie point records than required:");
            Debug.trace((String)("WARNING: product: " + this.getProductId()));
            tiePointGridHeight = numTiePointLinesFound;
        }
        parameters.put("sceneRasterWidth", this._sceneRasterWidth);
        parameters.put("sceneRasterHeight", this._sceneRasterHeight);
        parameters.put("tiePointGridWidth", tiePointGridWidth);
        parameters.put("tiePointGridHeight", tiePointGridHeight);
        parameters.put("tiePointSubSamplingX", this._tiePointSubSamplingX);
        parameters.put("tiePointSubSamplingY", this._tiePointSubSamplingY);
        this.setIODDVersion();
        this._sceneRasterStartTime = this.getRecordTime(firstMDSName, "dsr_time", 0);
        this._sceneRasterStopTime = this.getRecordTime(firstMDSName, "dsr_time", this._sceneRasterHeight - 1);
    }

    @Override
    protected String getDddbProductType() {
        String productType = MerisProductFile.getDddbProductTypeReplacement(this.getProductType(), this.getIODDVersion());
        return productType != null ? productType : super.getDddbProductType();
    }

    static String getDddbProductTypeReplacement(String productType, int ioddVersion) {
        if (ioddVersion == 5) {
            if (productType.startsWith(RR__1_PREFIX) || productType.startsWith(FR__1_PREFIX)) {
                return productType + IODD5_SUFFIX;
            }
            if (productType.startsWith(RR__2_PREFIX) || productType.startsWith(FR__2_PREFIX)) {
                return productType + IODD6_SUFFIX;
            }
        } else if (ioddVersion == 6) {
            if (productType.startsWith(RR__2_PREFIX) || productType.startsWith(FR__2_PREFIX)) {
                return productType + IODD6_SUFFIX;
            }
            if (productType.startsWith(FRS_1_PREFIX)) {
                return FR__1_PREFIX + productType.substring(FR__1_PREFIX.length()) + IODD6_SUFFIX;
            }
            if (productType.startsWith(FRS_2_PREFIX)) {
                return FR__2_PREFIX + productType.substring(FR__2_PREFIX.length()) + IODD6_SUFFIX;
            }
        } else if (ioddVersion >= 7 || ioddVersion == -1) {
            if (productType.startsWith(FRS_1_PREFIX)) {
                return FR__1_PREFIX + productType.substring(FR__1_PREFIX.length());
            }
            if (ioddVersion == 7) {
                if (productType.startsWith(RR__2_PREFIX) || productType.startsWith(FR__2_PREFIX)) {
                    return productType + IODD7_SUFFIX;
                }
                if (productType.startsWith(FRS_2_PREFIX)) {
                    return FR__2_PREFIX + productType.substring(FR__2_PREFIX.length()) + IODD7_SUFFIX;
                }
            } else if (productType.startsWith(FRS_2_PREFIX)) {
                return FR__2_PREFIX + productType.substring(FR__2_PREFIX.length());
            }
        }
        return null;
    }

    public int getIODDVersion() {
        return this._ioddVersion;
    }

    @Override
    public BandInfo createBandInfo(String bandName, int dataType, int spectralBandIndex, int sampleModel, int scalingMethod, float scalingOffset, float scalingFactor, String validExpression, FlagCoding flagCoding, String physicalUnit, String description, String dataSetName) {
        if (this.getIODDVersion() >= 7 && scalingMethod == 12 && MerisProductFile.isOldLinearYellowSubstanceScaling(bandName, scalingOffset, scalingFactor)) {
            this.getLogger().info("Out-of-date MERIS L2 format detected: band 'yellow_subs': changing scaling from LOG to LINEAR");
            scalingMethod = 11;
        }
        return super.createBandInfo(bandName, dataType, spectralBandIndex, sampleModel, scalingMethod, scalingOffset, scalingFactor, validExpression, flagCoding, physicalUnit, description, dataSetName);
    }

    private void setIODDVersion() {
        DSD flagsDSD;
        String softwareVersion;
        this._ioddVersion = 8;
        Field softwareVerField = this.getMPH().getParam("SOFTWARE_VER");
        if (softwareVerField != null && ((softwareVersion = softwareVerField.getAsString()).startsWith("MERIS") || softwareVersion.startsWith("MEGS-PC/7"))) {
            this._ioddVersion = 7;
        }
        if ((flagsDSD = this.getDSD("Flags")) != null) {
            Field sphDescParam;
            String sphDescriptor;
            boolean isImagette;
            if (this.getProductType().startsWith(RR__1_PREFIX) && flagsDSD.getRecordSize() < 3376) {
                this._ioddVersion = 5;
            }
            if (this.getProductType().startsWith(FR__1_PREFIX) && ((isImagette = (sphDescriptor = (sphDescParam = this.getSPH().getParam("SPH_DESCRIPTOR")).getAsString()).startsWith("MER_FR_IM")) && flagsDSD.getRecordSize() < 3472 || !isImagette && flagsDSD.getRecordSize() < 6736)) {
                this._ioddVersion = 5;
            }
        }
        if (this._ioddVersion == 5) {
            this.getLogger().warning("old product format: IODD version less than 6, 'detector_index' is not available");
        }
        if (this._ioddVersion != 5) {
            DSD[] dsds = this.getDsds();
            String oldMdsName = "Epsilon, OPT";
            for (DSD dsd : dsds) {
                if (dsd == null || !dsd.getDatasetName().contains(oldMdsName)) continue;
                this._ioddVersion = 6;
                this.getLogger().warning("old product format: IODD version less than 7, 'aero_alpha' is not available");
                break;
            }
        }
    }

    @Override
    public String getAutoGroupingPattern() {
        if (this.getProductType().contains("_1")) {
            return "radiance";
        }
        return "reflec";
    }

    @Override
    void setInvalidPixelExpression(Band band) {
        if (band.getName().startsWith("reflec_")) {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(0.0);
        } else {
            band.setNoDataValueUsed(false);
            band.setNoDataValue(0.0);
        }
    }

    @Override
    public String[] getDefaultBitmaskNames(String bandName) {
        if (bandName.startsWith("refl")) {
            return new String[]{BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_REFLECTANCES};
        }
        if (bandName.equals("water_vapour")) {
            return new String[]{BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_WATER_VAPOUR};
        }
        if (bandName.equals("algal_1")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_ALGAL_1};
        }
        if (bandName.equals("algal_2") || bandName.equals("yellow_subs") || bandName.equals("total_susp")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_ALGAL2_TSM_YS};
        }
        if (bandName.equals("photosyn_rad")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_PHOTOSYN_RAD};
        }
        if (bandName.equals("toa_veg")) {
            return new String[]{BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_TOA_VEG};
        }
        if (bandName.equals("boa_veg")) {
            return new String[]{BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_BOA_VEG};
        }
        if (bandName.equals("rect_refl_nir") || bandName.equals("rect_refl_red")) {
            return new String[]{BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_RECT_REFL};
        }
        if (bandName.equals("surf_press")) {
            return new String[]{BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_SURF_PRESS};
        }
        if (bandName.equals("aero_alpha") || bandName.equals("aero_epsilon") || bandName.startsWith("aero_opt_thick")) {
            return new String[]{BITMASKDEF_NAME_CLOUD, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_AERO_PRODUCTS};
        }
        if (bandName.equals("cloud_albedo")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_CLOUD_ALBEDO};
        }
        if (bandName.equals("cloud_opt_thick") || bandName.equals("cloud_type")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_CLOUD_OPT_THICK_AND_TYPE};
        }
        if (bandName.equals("cloud_top_press")) {
            return new String[]{BITMASKDEF_NAME_LAND, BITMASKDEF_NAME_WATER, BITMASKDEF_NAME_COASTLINE, BITMASKDEF_NAME_INVALID_CLOUD_TOP_PRESS};
        }
        if (bandName.equals("l2_flags")) {
            return new String[]{BITMASKDEF_NAME_COASTLINE};
        }
        return null;
    }

    @Override
    public Mask[] createDefaultMasks(String flagDsName) {
        if (this.getProductType().endsWith("1P")) {
            return new Mask[]{this.mask(BITMASKDEF_NAME_COASTLINE, null, "l1_flags.COASTLINE", Color.green, 0.0f), this.mask(BITMASKDEF_NAME_LAND, null, "l1_flags.LAND_OCEAN", new Color(51, 153, 0), 0.75f), this.mask(BITMASKDEF_NAME_WATER, null, "NOT l1_flags.LAND_OCEAN", new Color(153, 153, 255), 0.75f), this.mask(BITMASKDEF_NAME_COSMETIC, null, "l1_flags.COSMETIC", new Color(204, 153, 255), 0.5f), this.mask(BITMASKDEF_NAME_DUPLICATED, null, "l1_flags.DUPLICATED", Color.orange, 0.5f), this.mask(BITMASKDEF_NAME_GLINT_RISK, null, "l1_flags.GLINT_RISK", Color.magenta, 0.5f), this.mask(BITMASKDEF_NAME_SUSPECT, null, "l1_flags.SUSPECT", new Color(204, 102, 255), 0.5f), this.mask(BITMASKDEF_NAME_BRIGHT, null, "l1_flags.BRIGHT", Color.yellow, 0.5f), this.mask(BITMASKDEF_NAME_INVALID, null, "l1_flags.INVALID", Color.red, 0.0f)};
        }
        if (this.getProductType().endsWith("2P")) {
            if (this.getIODDVersion() == 6 || this.getIODDVersion() == 5) {
                return new Mask[]{this.mask(BITMASKDEF_NAME_COASTLINE, null, "l2_flags.COASTLINE", Color.green, 0.0f), this.mask(BITMASKDEF_NAME_LAND, null, "l2_flags.LAND", new Color(102, 102, 102), 0.0f), this.mask(BITMASKDEF_NAME_CLOUD, null, "l2_flags.CLOUD", new Color(255, 255, 255), 0.0f), this.mask(BITMASKDEF_NAME_WATER, null, "l2_flags.WATER", new Color(0, 0, 0), 0.0f), this.mask(BITMASKDEF_NAME_INVALID_REFLECTANCES, "pixels flagged for invalid reflectances", "l2_flags.PCD_1_13 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_WATER_VAPOUR, "pixels flagged for invalid water vapour", "l2_flags.PCD_14 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL_1, "water pixels flagged for invalid algal1", "l2_flags.WATER AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL2_TSM_YS, "water pixels flagged for invalid algal2 and yellow_subs and total_susp", "l2_flags.WATER AND (l2_flags.PCD_16 OR l2_flags.PCD_17)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_PHOTOSYN_RAD, "water pixels flagged for invalid PAR", "l2_flags.WATER AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_TOA_VEG, "land pixels flagged for invalid toa_veg", "l2_flags.LAND AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_BOA_VEG, "land pixels flagged for invalid boa_veg", "l2_flags.LAND AND l2_flags.PCD_17", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_RECT_REFL, "land pixels flagged for invalid rectified reflectances", "l2_flags.LAND AND l2_flags.PCD_16", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_SURF_PRESS, "land pixels flagged for invalid surf_press", "l2_flags.LAND AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_AERO_PRODUCTS, "water pixels flagged for invalid aero_epsilon and aero_opt_thick_(i)", "l2_flags.PCD_19 AND (l2_flags.LAND OR l2_flags.WATER)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_ALBEDO, "cloud pixels flagged for invalid cloud_albedo", "l2_flags.CLOUD AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_OPT_THICK_AND_TYPE, "cloud pixels flagged for invalid cloud_opt_thick and cloud_type", "l2_flags.CLOUD AND l2_flags.PCD_19", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_TOP_PRESS, "cloud pixels flagged for invalid cloud_top_press", "l2_flags.CLOUD AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_HIGH_GLINT, null, "l2_flags.HIGH_GLINT", new Color(204, 0, 204), 0.5f), this.mask(BITMASKDEF_NAME_MEDIUM_GLINT, null, "l2_flags.MEDIUM_GLINT", new Color(255, 51, 255), 0.5f), this.mask(BITMASKDEF_NAME_ICE_HAZE, null, "l2_flags.ICE_HAZE", Color.yellow, 0.5f), this.mask(BITMASKDEF_NAME_ABSOA_CONT, null, "l2_flags.ABSOA_CONT", new Color(0, 102, 255), 0.5f), this.mask(BITMASKDEF_NAME_ABSOA_DUST, null, "l2_flags.ABSOA_DUST", new Color(0, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_S, null, "l2_flags.CASE2_S", new Color(255, 255, 153), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_ANOM, null, "l2_flags.CASE2_ANOM", new Color(153, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_Y, null, "l2_flags.CASE2_Y", new Color(204, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_DARK_VEGETATION, null, "l2_flags.DDV", new Color(0, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BRIGHT, null, "l2_flags.TOAVI_BRIGHT", new Color(255, 204, 204), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BAD, null, "l2_flags.TOAVI_BAD", new Color(255, 153, 102), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_CSI, null, "l2_flags.TOAVI_CSI", new Color(255, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_WS, null, "l2_flags.TOAVI_WS", new Color(204, 102, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_INVAL_REC, null, "l2_flags.TOAVI_INVAL_REC", new Color(153, 51, 0), 0.5f), this.mask(BITMASKDEF_NAME_P_CONFIDENCE, null, "l2_flags.P_CONFIDENCE", new Color(255, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_LOW_PRESSURE, null, "l2_flags.LOW_PRESSURE", new Color(204, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_COSMETIC, null, "l2_flags.COSMETIC", new Color(204, 153, 255), 0.5f), this.mask(BITMASKDEF_NAME_SUSPECT, null, "l2_flags.SUSPECT", new Color(204, 102, 255), 0.5f), this.mask(BITMASKDEF_NAME_PCD_1_13, null, "l2_flags.PCD_1_13", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_14, null, "l2_flags.PCD_14", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_15, null, "l2_flags.PCD_15", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_16, null, "l2_flags.PCD_16", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_17, null, "l2_flags.PCD_17", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_18, null, "l2_flags.PCD_18", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_19, null, "l2_flags.PCD_19", Color.red, 0.0f)};
            }
            if (this.getIODDVersion() == 7) {
                return new Mask[]{this.mask(BITMASKDEF_NAME_COASTLINE, null, "l2_flags.COASTLINE", Color.green, 0.0f), this.mask(BITMASKDEF_NAME_LAND, null, "l2_flags.LAND", new Color(102, 102, 102), 0.0f), this.mask(BITMASKDEF_NAME_CLOUD, null, "l2_flags.CLOUD", new Color(255, 255, 255), 0.0f), this.mask(BITMASKDEF_NAME_WATER, null, "l2_flags.WATER", new Color(0, 0, 0), 0.0f), this.mask(BITMASKDEF_NAME_INVALID_REFLECTANCES, "Pixels flagged for invalid reflectances", "l2_flags.PCD_1_13 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_WATER_VAPOUR, "Pixels flagged for invalid water vapour", "l2_flags.PCD_14 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL_1, "Water pixels flagged for invalid algal1", "l2_flags.WATER AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL2_TSM_YS, "Water pixels flagged for invalid algal2 and yellow_subs and total_susp", "l2_flags.WATER AND (l2_flags.PCD_16 OR l2_flags.PCD_17)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_PHOTOSYN_RAD, "Water pixels flagged for invalid PAR", "l2_flags.WATER AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_TOA_VEG, "Land pixels flagged for invalid toa_veg", "l2_flags.LAND AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_BOA_VEG, "Land pixels flagged for invalid boa_veg", "l2_flags.LAND AND l2_flags.PCD_17", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_RECT_REFL, "Land pixels flagged for invalid rectified reflectances", "l2_flags.LAND AND l2_flags.PCD_16", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_SURF_PRESS, "Land pixels flagged for invalid surf_press", "l2_flags.LAND AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_AERO_PRODUCTS, "Land and water pixels flagged for invalid aero_alpha and aero_opt_thick_(i)", "l2_flags.PCD_19 AND (l2_flags.LAND OR l2_flags.WATER)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_ALBEDO, "Cloud pixels flagged for invalid cloud_albedo", "l2_flags.CLOUD AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_OPT_THICK_AND_TYPE, "Cloud pixels flagged for invalid cloud_opt_thick and cloud_type", "l2_flags.CLOUD AND l2_flags.PCD_19", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_TOP_PRESS, "Cloud pixels flagged for invalid cloud_top_press", "l2_flags.CLOUD AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_LOW_SUN, null, "l2_flags.LOW_SUN", new Color(153, 0, 153), 0.5f), this.mask(BITMASKDEF_NAME_HIGH_GLINT, null, "l2_flags.HIGH_GLINT", new Color(204, 0, 204), 0.5f), this.mask(BITMASKDEF_NAME_MEDIUM_GLINT, null, "l2_flags.MEDIUM_GLINT", new Color(255, 51, 255), 0.5f), this.mask(BITMASKDEF_NAME_ICE_HAZE, null, "l2_flags.ICE_HAZE", Color.yellow, 0.5f), this.mask(BITMASKDEF_NAME_LAND_AEROSOL_ON, null, "l2_flags.LARS_ON", new Color(51, 51, 255), 0.25f), this.mask(BITMASKDEF_NAME_ABSOA_DUST, null, "l2_flags.ABSOA_DUST", new Color(0, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_BPAC_ON, null, "l2_flags.BPAC_ON", new Color(153, 255, 204), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_S, null, "l2_flags.CASE2_S", new Color(255, 255, 153), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_ANOM, null, "l2_flags.CASE2_ANOM", new Color(153, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_Y, null, "l2_flags.CASE2_Y", new Color(204, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_UNCERTAIN_AEROSOL_MODEL, null, "l2_flags.OOADB", new Color(0, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BRIGHT, null, "l2_flags.TOAVI_BRIGHT", new Color(255, 204, 204), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BAD, null, "l2_flags.TOAVI_BAD", new Color(255, 153, 102), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_CSI, null, "l2_flags.TOAVI_CSI", new Color(255, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_WS, null, "l2_flags.TOAVI_WS", new Color(204, 102, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_INVAL_REC, null, "l2_flags.TOAVI_INVAL_REC", new Color(153, 51, 0), 0.5f), this.mask(BITMASKDEF_NAME_LOW_PRESSURE, null, "l2_flags.LOW_PRESSURE", new Color(204, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_WHITE_SCATTERER, null, "l2_flags.WHITE_SCATTERER", new Color(204, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_COSMETIC, null, "l2_flags.COSMETIC", new Color(204, 153, 255), 0.5f), this.mask(BITMASKDEF_NAME_SUSPECT, null, "l2_flags.SUSPECT", new Color(204, 102, 255), 0.5f), this.mask(BITMASKDEF_NAME_PCD_1_13, null, "l2_flags.PCD_1_13", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_14, null, "l2_flags.PCD_14", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_15, null, "l2_flags.PCD_15", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_16, null, "l2_flags.PCD_16", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_17, null, "l2_flags.PCD_17", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_18, null, "l2_flags.PCD_18", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_19, null, "l2_flags.PCD_19", Color.red, 0.0f)};
            }
            if (this.getIODDVersion() == 8) {
                return new Mask[]{this.mask(BITMASKDEF_NAME_COASTLINE, null, "l2_flags.COASTLINE", Color.green, 0.0f), this.mask(BITMASKDEF_NAME_LAND, null, "l2_flags.LAND", new Color(102, 102, 102), 0.0f), this.mask(BITMASKDEF_NAME_CLOUD, null, "l2_flags.CLOUD", new Color(255, 255, 255), 0.0f), this.mask(BITMASKDEF_NAME_WATER, null, "l2_flags.WATER", new Color(0, 0, 0), 0.0f), this.mask(BITMASKDEF_NAME_INVALID_REFLECTANCES, "Pixels flagged for invalid reflectances", "l2_flags.PCD_1_13 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_WATER_VAPOUR, "Pixels flagged for invalid water vapour", "l2_flags.PCD_14 AND (l2_flags.LAND OR l2_flags.WATER OR l2_flags.CLOUD)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL_1, "Water pixels flagged for invalid algal1", "l2_flags.WATER AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_ALGAL2_TSM_YS, "Water pixels flagged for invalid algal2 and yellow_subs and total_susp", "l2_flags.WATER AND (l2_flags.PCD_16 OR l2_flags.PCD_17)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_PHOTOSYN_RAD, "Water pixels flagged for invalid PAR", "l2_flags.WATER AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_TOA_VEG, "Land pixels flagged for invalid toa_veg", "l2_flags.LAND AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_BOA_VEG, "Land pixels flagged for invalid boa_veg", "l2_flags.LAND AND l2_flags.PCD_17", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_RECT_REFL, "Land pixels flagged for invalid rectified reflectances", "l2_flags.LAND AND l2_flags.PCD_16", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_SURF_PRESS, "Land pixels flagged for invalid surf_press", "l2_flags.LAND AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_AERO_PRODUCTS, "Land and water pixels flagged for invalid aero_alpha and aero_opt_thick_(i)", "l2_flags.PCD_19 AND (l2_flags.LAND OR l2_flags.WATER)", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_ALBEDO, "Cloud pixels flagged for invalid cloud_albedo", "l2_flags.CLOUD AND l2_flags.PCD_18", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_OPT_THICK_AND_TYPE, "Cloud pixels flagged for invalid cloud_opt_thick and cloud_type", "l2_flags.CLOUD AND l2_flags.PCD_19", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_INVALID_CLOUD_TOP_PRESS, "Cloud pixels flagged for invalid cloud_top_press", "l2_flags.CLOUD AND l2_flags.PCD_15", Color.black, 0.0f), this.mask(BITMASKDEF_NAME_LOW_SUN, null, "l2_flags.LOW_SUN", new Color(153, 0, 153), 0.5f), this.mask(BITMASKDEF_NAME_HIGH_GLINT, null, "l2_flags.HIGH_GLINT", new Color(204, 0, 204), 0.5f), this.mask(BITMASKDEF_NAME_MEDIUM_GLINT, null, "l2_flags.MEDIUM_GLINT", new Color(255, 51, 255), 0.5f), this.mask(BITMASKDEF_NAME_ICE_HAZE, null, "l2_flags.ICE_HAZE", Color.yellow, 0.5f), this.mask(BITMASKDEF_NAME_ABSOA_DUST, null, "l2_flags.ABSOA_DUST", new Color(0, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_BPAC_ON, null, "l2_flags.BPAC_ON", new Color(153, 255, 204), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_S, null, "l2_flags.CASE2_S", new Color(255, 255, 153), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_ANOM, null, "l2_flags.CASE2_ANOM", new Color(153, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_CASE2_Y, null, "l2_flags.CASE2_Y", new Color(204, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_SNOW_ICE, null, "l2_flags.SNOW_ICE", new Color(255, 255, 153), 0.5f), this.mask(BITMASKDEF_NAME_DENSE_DARK_VEG, null, "l2_flags.DDV", new Color(51, 51, 255), 0.25f), this.mask(BITMASKDEF_NAME_UNCERTAIN_AEROSOL_MODEL, null, "l2_flags.OOADB", new Color(0, 204, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BRIGHT, null, "l2_flags.TOAVI_BRIGHT", new Color(255, 204, 204), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_BAD, null, "l2_flags.TOAVI_BAD", new Color(255, 153, 102), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_CSI, null, "l2_flags.TOAVI_CSI", new Color(255, 153, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_WS, null, "l2_flags.TOAVI_WS", new Color(204, 102, 0), 0.5f), this.mask(BITMASKDEF_NAME_TOAVI_INVAL_REC, null, "l2_flags.TOAVI_INVAL_REC", new Color(153, 51, 0), 0.5f), this.mask(BITMASKDEF_NAME_WHITE_SCATTERER, null, "l2_flags.WHITE_SCATTERER", new Color(204, 204, 255), 0.5f), this.mask(BITMASKDEF_NAME_COSMETIC, null, "l2_flags.COSMETIC", new Color(204, 153, 255), 0.5f), this.mask(BITMASKDEF_NAME_SUSPECT, null, "l2_flags.SUSPECT", new Color(204, 102, 255), 0.5f), this.mask(BITMASKDEF_NAME_PCD_1_13, null, "l2_flags.PCD_1_13", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_14, null, "l2_flags.PCD_14", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_15, null, "l2_flags.PCD_15", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_16, null, "l2_flags.PCD_16", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_17, null, "l2_flags.PCD_17", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_18, null, "l2_flags.PCD_18", Color.red, 0.0f), this.mask(BITMASKDEF_NAME_PCD_19, null, "l2_flags.PCD_19", Color.red, 0.0f)};
            }
            return new Mask[0];
        }
        return new Mask[0];
    }

    private float[] createFloatArray(Field field, float scale) {
        if (field != null) {
            float[] values = new float[field.getNumElems()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = field.getElemFloat(i) * scale;
            }
            return values;
        }
        return null;
    }

    private static boolean isOldLinearYellowSubstanceScaling(String bandName, float scalingOffset, float scalingFactor) {
        float value = scalingOffset + 1.0f * scalingFactor;
        return bandName.equals("yellow_subs") && value >= 0.0f;
    }
}

