/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.framework.datamodel.Pointing;
import org.esa.beam.framework.datamodel.PointingFactory;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGridPointing;

public class MerisPointingFactory
implements PointingFactory {
    private static final String[] PRODUCT_TYPES = new String[]{"MER_RR__1P", "MER_RR__2P", "MER_FR__1P", "MER_FR__2P", "MER_FRS_1P", "MER_FRS_2P", "MER_FSG_1P", "MER_FRG_1P"};

    public String[] getSupportedProductTypes() {
        return PRODUCT_TYPES;
    }

    public Pointing createPointing(RasterDataNode raster) {
        Product product = raster.getProduct();
        return new TiePointGridPointing(raster.getGeoCoding(), product.getTiePointGrid("sun_zenith"), product.getTiePointGrid("sun_azimuth"), product.getTiePointGrid("view_zenith"), product.getTiePointGrid("view_azimuth"), product.getTiePointGrid("dem_alt"));
    }
}

