/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.envisat.DSD;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.ProductFile;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.dataio.envisat.RecordInfo;
import org.esa.beam.dataio.envisat.RecordReader;
import org.esa.beam.util.Debug;

class LineInterleavedRecordReader
extends RecordReader {
    private final long recordLength;
    private final long recordOffset;
    private final long headerSize;

    LineInterleavedRecordReader(ProductFile productFile, DSD dsd, RecordInfo recordInfo) throws IOException {
        super(productFile, dsd, recordInfo);
        long rLength = 0L;
        long rOffset = 0L;
        boolean currentDsdReached = false;
        String[] mdsNames = productFile.getValidDatasetNames(77);
        this.headerSize = productFile.getDSD(mdsNames[0]).getDatasetOffset();
        for (int i = 0; i < mdsNames.length; ++i) {
            String mdsName = mdsNames[i];
            DSD currentDSD = productFile.getDSD(mdsName);
            rLength += (long)currentDSD.getRecordSize();
            if (currentDSD == dsd) {
                currentDsdReached = true;
            }
            if (currentDsdReached) continue;
            rOffset += (long)currentDSD.getRecordSize();
        }
        this.recordLength = rLength;
        this.recordOffset = rOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record readRecord(int index, Record record) throws IOException {
        ImageInputStream istream;
        if (record == null) {
            record = this.createCompatibleRecord();
        }
        Debug.assertTrue((record.getInfo() == this.getRecordInfo() ? 1 : 0) != 0);
        ProductFile productFile = this.getProductFile();
        if (this.getDSD().getDatasetType() == 'M') {
            index = productFile.getMappedMDSRIndex(index);
        }
        long pos = this.headerSize + (long)index * this.recordLength + this.recordOffset;
        ImageInputStream imageInputStream = istream = productFile.getDataInputStream();
        synchronized (imageInputStream) {
            istream.seek(pos);
            record.readFrom(istream);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldSegment(int sourceY, long fieldOffset, int dataFieldSampleSize, int minX, int maxX, Field field) throws IOException {
        ImageInputStream istream;
        if (this.getDSD().getDatasetType() == 'M') {
            sourceY = this.getProductFile().getMappedMDSRIndex(sourceY);
        }
        long pos = this.headerSize + (long)sourceY * this.recordLength + this.recordOffset + fieldOffset + (long)(minX * dataFieldSampleSize * field.getData().getElemSize());
        ImageInputStream imageInputStream = istream = this.getProductFile().getDataInputStream();
        synchronized (imageInputStream) {
            istream.seek(pos);
            field.getData().readFrom(minX * dataFieldSampleSize, (maxX - minX + 1) * dataFieldSampleSize, istream);
        }
    }
}

