/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.text.ParseException;
import java.util.Date;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.beam.dataio.envisat.HeaderParseException;
import org.esa.beam.dataio.envisat.Record;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Guardian;

public final class Header {
    private final Record _params;

    public Header(Record params) {
        Guardian.assertNotNull((String)"params", (Object)params);
        this._params = params;
    }

    public Record getParams() {
        return this._params;
    }

    public final boolean hasParam(String key) {
        return this.getParamIndex(key) >= 0;
    }

    public final boolean isEmpty() {
        return this.getNumParams() == 0;
    }

    public final int getNumParams() {
        return this._params.getNumFields();
    }

    public final Field getParamAt(int index) throws IndexOutOfBoundsException {
        return this._params.getFieldAt(index);
    }

    public Field getParam(String key) {
        return this._params.getField(key);
    }

    public int getParamIndex(String key) {
        return this._params.getFieldIndex(key);
    }

    public int getParamNumElems(String key) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getNumElems();
    }

    public int getParamInt(String key) throws HeaderEntryNotFoundException {
        return this.getParamInt(key, 0);
    }

    public int getParamInt(String key, int elemIndex) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getData().getElemIntAt(elemIndex);
    }

    public long getParamUInt(String key) throws HeaderEntryNotFoundException {
        return this.getParamUInt(key, 0);
    }

    public long getParamUInt(String key, int elemIndex) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getData().getElemUIntAt(elemIndex);
    }

    public float getParamFloat(String key) throws HeaderEntryNotFoundException {
        return this.getParamFloat(key, 0);
    }

    public float getParamFloat(String key, int elemIndex) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getData().getElemFloatAt(elemIndex);
    }

    public double getParamDouble(String key) throws HeaderEntryNotFoundException {
        return this.getParamDouble(key, 0);
    }

    public double getParamDouble(String key, int elemIndex) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getData().getElemDoubleAt(elemIndex);
    }

    public String getParamString(String key) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getAsString();
    }

    public Date getParamDate(String key) throws HeaderParseException, HeaderEntryNotFoundException {
        return this.getParamUTC(key).getAsDate();
    }

    public ProductData.UTC getParamUTC(String key) throws HeaderParseException, HeaderEntryNotFoundException {
        Field field = this.getParamImpl(key);
        if (field.getDataType() == 41) {
            try {
                return ProductData.UTC.parse((String)field.getAsString());
            }
            catch (ParseException e) {
                throw new HeaderParseException(e.getMessage());
            }
        }
        if (field.getDataType() == 51) {
            return (ProductData.UTC)field.getData();
        }
        throw new HeaderParseException("Illegal product format: value header entry '" + key + "' is not convertible to UTC date");
    }

    public final int getParamDataType(String key) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getInfo().getDataType();
    }

    public String getParamUnit(String key) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getInfo().getPhysicalUnit();
    }

    public String getParamDescription(String key) throws HeaderEntryNotFoundException {
        return this.getParamImpl(key).getInfo().getDescription();
    }

    public String toString() {
        int n = this.getNumParams();
        StringBuffer sb = new StringBuffer(32 + 32 * n);
        sb.append("Header[\n");
        sb.append(this._params.toString());
        sb.append(']');
        return sb.toString();
    }

    private Field getParamImpl(String key) throws HeaderEntryNotFoundException {
        Guardian.assertNotNullOrEmpty((String)"key", (String)key);
        Field param = this.getParam(key);
        if (param == null) {
            throw new HeaderEntryNotFoundException("Illegal product format: header entry '" + key + "' not found.");
        }
        return param;
    }
}

