/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;

public class FieldRef {
    String _datasetName;
    int _fieldIndex;
    int _elemIndex;

    FieldRef(String datasetName, int fieldIndex) {
        this(datasetName, fieldIndex, -1);
    }

    FieldRef(String datasetName, int fieldIndex, int elemIndex) {
        Guardian.assertNotNullOrEmpty((String)"datasetName", (String)datasetName);
        if (fieldIndex < 0 || elemIndex < -1) {
            throw new IllegalArgumentException("invalid FieldRef argument");
        }
        this._datasetName = datasetName;
        this._fieldIndex = fieldIndex;
        this._elemIndex = elemIndex;
    }

    public static FieldRef parse(String fieldRefStr) throws NumberFormatException {
        try {
            String fieldIndexTestStr;
            int dotPos1 = fieldRefStr.lastIndexOf(46);
            String datasetName = fieldRefStr.substring(0, dotPos1).trim();
            String fieldIndexStr = fieldRefStr.substring(dotPos1 + 1).trim();
            int dotPos2 = datasetName.lastIndexOf(46);
            if (dotPos2 >= 0 && StringUtils.isIntegerString((String)(fieldIndexTestStr = datasetName.substring(dotPos2 + 1).trim()))) {
                String elemIndexStr = fieldIndexStr;
                fieldIndexStr = fieldIndexTestStr;
                datasetName = datasetName.substring(0, dotPos2).trim();
                int fieldIndex = Integer.parseInt(fieldIndexStr) - 1;
                int elemIndex = Integer.parseInt(elemIndexStr) - 1;
                return new FieldRef(datasetName, fieldIndex, elemIndex);
            }
            int fieldIndex = Integer.parseInt(fieldIndexStr) - 1;
            return new FieldRef(datasetName, fieldIndex);
        }
        catch (NumberFormatException e) {
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new NumberFormatException("invalid field reference string: " + fieldRefStr);
    }

    public String format() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDatasetName());
        sb.append('.');
        sb.append(this.getFieldIndex() + 1);
        if (this.getElemIndex() >= 0) {
            sb.append('.');
            sb.append(this.getElemIndex() + 1);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldRef[");
        sb.append(this.format());
        sb.append("]");
        return sb.toString();
    }

    public String getDatasetName() {
        return this._datasetName;
    }

    public int getFieldIndex() {
        return this._fieldIndex;
    }

    public int getElemIndex() {
        return this._elemIndex;
    }
}

