/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.dataio.envisat.DataItemInfo;
import org.esa.beam.dataio.envisat.Field;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;

public class FieldInfo
extends DataItemInfo {
    private final int _numDataElems;

    FieldInfo(String fieldName, int dataType, int numDataElems, String physicalUnit, String description) {
        super(fieldName, dataType, physicalUnit, description);
        Debug.assertTrue((numDataElems >= 1 ? 1 : 0) != 0, (String)"number of data elements must be greater zero");
        this._numDataElems = numDataElems;
    }

    public Field createField() {
        return new Field(this);
    }

    public final int getNumDataElems() {
        return this._numDataElems;
    }

    public final int getSizeInBytes() {
        return this.getNumDataElems() * FieldInfo.getDataTypeElemSize(this.getDataType());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldInfo[");
        sb.append("'");
        sb.append(this.getName());
        sb.append("',");
        sb.append(ProductData.getTypeString((int)this.getDataType()));
        sb.append(",");
        sb.append(this.getNumDataElems());
        sb.append(",'");
        sb.append(this.getPhysicalUnit());
        sb.append("','");
        sb.append(this.getDescription());
        sb.append("']");
        return sb.toString();
    }
}

