/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.beam.dataio.envisat.EnvisatConstants;
import org.esa.beam.dataio.envisat.EnvisatProductReader;
import org.esa.beam.dataio.envisat.ProductFile;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.IllegalFileFormatException;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class EnvisatProductReaderPlugIn
implements ProductReaderPlugIn {
    public String[] getFormatNames() {
        return new String[]{"ENVISAT"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".N1", ".E1", ".E2", ".zip", ".gz"};
    }

    public String getDescription(Locale name) {
        return "ENVISAT MERIS, AATSR, ASAR and ERS1/2 SAR products";
    }

    public DecodeQualification getDecodeQualification(Object input) {
        if (input instanceof String) {
            if (ProductFile.getProductType(new File((String)input)) != null) {
                return DecodeQualification.INTENDED;
            }
        } else if (input instanceof File) {
            InputStream inputStream;
            File inputFile = (File)input;
            String fileName = inputFile.getName().toUpperCase();
            for (String ext : EnvisatConstants.EXTENSIONS) {
                if (!fileName.endsWith(ext) && !fileName.endsWith(ext + ".ZIP") && !fileName.endsWith(ext + ".GZ")) continue;
                return DecodeQualification.INTENDED;
            }
            if (!fileName.endsWith(".ZIP") && !fileName.endsWith(".GZ")) {
                return DecodeQualification.UNABLE;
            }
            if (ProductFile.getProductType(inputFile) != null) {
                return DecodeQualification.INTENDED;
            }
            try {
                inputStream = EnvisatProductReaderPlugIn.getInflaterInputStream(inputFile);
            }
            catch (IOException e) {
                return DecodeQualification.UNABLE;
            }
            MemoryCacheImageInputStream dataInputStream = new MemoryCacheImageInputStream(inputStream);
            String productType = ProductFile.getProductType(dataInputStream);
            try {
                dataInputStream.close();
                inputStream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            if (productType != null) {
                return DecodeQualification.INTENDED;
            }
        } else if (input instanceof ImageInputStream && ProductFile.getProductType((ImageInputStream)input) != null) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, ImageInputStream.class, ProductFile.class};
    }

    public ProductReader createReaderInstance() {
        return new EnvisatProductReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    static InputStream getInflaterInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz") && !file.getName().endsWith(".tar.gz")) {
            try {
                return EnvisatProductReaderPlugIn.createGZIPInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return EnvisatProductReaderPlugIn.createZIPInputStream(file);
    }

    private static InputStream createZIPInputStream(File file) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        if (productZip.size() != 1) {
            throw new IllegalFileFormatException("Illegal ZIP format, single file entry expected.");
        }
        Enumeration<? extends ZipEntry> entries = productZip.entries();
        ZipEntry zipEntry = entries.nextElement();
        if (zipEntry == null || zipEntry.isDirectory()) {
            throw new IllegalFileFormatException("Illegal ZIP format, single file entry expected.");
        }
        return productZip.getInputStream(zipEntry);
    }

    private static InputStream createGZIPInputStream(File file) throws IOException {
        return new GZIPInputStream(new FileInputStream(file));
    }
}

