/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public class DSD {
    private final int index;
    private final String datasetName;
    private final char datasetType;
    private final String fileName;
    private long datasetOffset;
    private long datasetSize;
    private final int numRecords;
    private int recordSize;

    public DSD(int index, String datasetName, char datasetType, String fileName, long datasetOffset, long datasetSize, int numRecords, int recordSize) {
        Debug.assertTrue((datasetName != null ? 1 : 0) != 0);
        this.index = index;
        this.datasetName = datasetName;
        this.datasetType = datasetType;
        this.fileName = fileName;
        this.datasetOffset = datasetOffset;
        this.datasetSize = datasetSize;
        this.numRecords = numRecords;
        this.recordSize = recordSize;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getDatasetName() {
        return this.datasetName;
    }

    public final char getDatasetType() {
        return this.datasetType;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final long getDatasetOffset() {
        return this.datasetOffset;
    }

    public final long getDatasetSize() {
        return this.datasetSize;
    }

    public final int getNumRecords() {
        return this.numRecords;
    }

    public final int getRecordSize() {
        return this.recordSize;
    }

    public final void adjust(long datasetOffset, int recordSize) {
        Guardian.assertGreaterThan((String)"datasetOffset", (long)datasetOffset, (long)0L);
        Guardian.assertGreaterThan((String)"recordSize", (long)recordSize, (long)0L);
        this.datasetOffset = datasetOffset;
        this.recordSize = recordSize;
        this.datasetSize = this.numRecords * this.recordSize;
    }

    public final boolean isDatasetEmpty() {
        return this.datasetSize == 0L || this.numRecords == 0 || this.recordSize == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("DSD(");
        sb.append(this.index);
        sb.append(")['");
        sb.append(this.datasetName);
        sb.append("','");
        sb.append(this.datasetType);
        sb.append("','");
        sb.append(this.fileName);
        sb.append("',");
        sb.append(this.datasetOffset);
        sb.append(',');
        sb.append(this.datasetSize);
        sb.append(',');
        sb.append(this.numRecords);
        sb.append(',');
        sb.append(this.recordSize);
        sb.append(']');
        return sb.toString();
    }
}

